#!/usr/bin/env python
# coding: utf-8

# # Importación de librerías y carga de datos

# In[1]:


import pickle
import numpy as np
import gradio as gr
import sklearn
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.gaussian_process import GaussianProcessRegressor


filename = 'DatosEP3.csv'
names0 = ['zB', 'FI', 'Q', 'IEP']
dataset=pd.read_csv(filename, names=names0)

y = dataset['IEP']
X = dataset.drop('IEP', axis=1)
validation_size = 0.20
seed = 0
X_train, X_test, Y_train, Y_test = train_test_split(X, y, test_size=validation_size, random_state=seed)

modelodef=GaussianProcessRegressor(alpha=0.00001, normalize_y=False)
modelodef.fit(X_train, Y_train)


# In[2]:


pickle.dump(modelodef, open("modelodef.pkl", "wb"))


def IEPML(zB, FI, Q):
    modelodef = pickle.load(open("modelodef.pkl", "rb"))
    prediction0 = modelodef.predict([[zB, FI, Q]])
    prediction = np.round(prediction0,3)
    return prediction

title = "CALCULATION OF THE INFLUENCE FACTOR RELATING ELASTIC AND ELASTOPLASTIC SETTLEMENTS"
description = "This app corresponds to the research paper: COUPLING NUMERICAL MODELLING AND MACHINE LEARNING TO EVALUATE ELASTOPLASTIC SETTLEMENTS OF SHALLOW FOUNDATIONS"
article = """
            Notes:
            - Click submit/enviar button to obtain the Influence Factor prediction
            - Click clear/limpiar button to refresh text
            - Please note the application ranges of the variables in the above-referenced paper (in publishing process). Outside these ranges, the predictions may not be reliable
            - The ranges of application are:
                - Angle of internal friction: between 25º and 45º
                - z/B: between 0.25 and 7.50
                - Ratio between the applied pressure to the ultimate bearing capacity: between 0.2 and 0.9
            - For cases in which there is no bedrock under the foundation, a limit value of z/B equal to 7.5 has to be used due according to the above referenced paper
            - As a decimal separator you can use either a point or a comma
           """        
                 
app = gr.Interface(
    IEPML,
    inputs=[
        gr.Number(value=1, label="z/B"),
        gr.Number(value=30, label="Angle of internal friction (º)"),
        gr.Number(value=0.33, label="Ratio between applied load and ultimate load (q/qult)"),
        
    ],
    outputs=[gr.Text(label="Influence Factor")],
    title=title,
    description=description,
    article = article,
    theme="dark-seafoam"
)


app.launch()