import pickle
import numpy as np
import gradio as gr
import sklearn
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.experimental import enable_iterative_imputer
from sklearn.impute import IterativeImputer
from sklearn.model_selection import KFold
from sklearn.ensemble import ExtraTreesRegressor
from sklearn.ensemble import GradientBoostingRegressor
from sklearn.ensemble import StackingRegressor
from sklearn.ensemble import RandomForestRegressor

filename = 'DatabaseFinal0.csv'
names0 = ['LL',"IP" ,"e0",'w', 'cc']
dataset=pd.read_csv(filename, names=names0)

y = dataset['cc']
X0 = dataset.drop('cc', axis=1)
impute_it = IterativeImputer()
X2=impute_it.fit_transform(X0)
X = pd.DataFrame(X2, columns=['LL',"IP" ,"e0",'w'])
validation_size = 0.2
seed = 10
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=validation_size, random_state=seed)
model1 =ExtraTreesRegressor(max_depth=15, max_features=None, n_estimators=500,random_state=100,min_samples_split=12)
model1= model1.fit(X_train, y_train)
model2 =GradientBoostingRegressor(learning_rate=0.007, max_depth=2,n_estimators=1650, random_state=100,min_samples_split=9,max_features= 'log2')
model2= model2.fit(X_train, y_train)
model3 =RandomForestRegressor(n_estimators= 1000,min_samples_split= 11, min_samples_leaf= 1,
                                max_features= None,max_depth= 6,bootstrap= True,random_state=100)
model3= model3.fit(X_train, y_train)
level1 = list()
level1.append(('ET', model1))
level1.append(('GBR', model2))
level2 = model3
cv = KFold(n_splits=10, random_state=100,shuffle=True)
modelodef = StackingRegressor(estimators=level1, final_estimator=level2, cv=cv, passthrough=True)
modelodef.fit(X_train, y_train)

pickle.dump(modelodef, open("modelodef.pkl", "wb"))


def cc(LL,IP,e0,w):
    modelodef = pickle.load(open("modelodef.pkl", "rb"))
    prediction0 = modelodef.predict([[LL,IP,e0,w]])
    prediction = np.round(prediction0,3)
    return prediction

title = "A SUPER-LEARNER MACHINE LEARNING MODEL FOR A GLOBAL PREDICTION OF COMPRESSION INDEX IN CLAYS"
#####################description = "This app corresponds to the research paper: A super-learner machine learning model for a global prediction of compression index in clays"
description = ""
article = """
            Notes:
            - Click submit/enviar button to obtain the Compression index prediction
            - Click clear/limpiar button to refresh text
            - Please note the application ranges of the variables in the above-referenced paper (in publication process). Outside these ranges, the predictions may not be reliable
            - As a decimal separator you can use either a point or a comma
           """        

#my_theme = gr.Theme.from_hub("bethecloud/storj_theme")

my_theme = gr.Theme.from_hub("derekzen/stardust")


app = gr.Interface(
    cc,
    inputs=[
        gr.Number(value=30, label="Liquid limit (%)"),
        gr.Number(value=15, label="Plasticity index (%)"),
        gr.Number(value=0.800, label="Initial void ratio"),
        gr.Number(value=25, label="Natural water content (%)"),
        
    ],
    outputs=[gr.Text(label="Compression index")],
    title=title,
    description=description,
    article = article,
    theme=my_theme
)

app.launch()