#libraries
import gradio as gr
from gradio.mix import Parallel

#variables, functions and parameters
model1 = gr.Interface.load("huggingface/gpt2")
model2 = gr.Interface.load("huggingface/EleutherAI/gpt-j-6B")
model3 = gr.Interface.load("huggingface/EleutherAI/gpt-neo-1.3B")

#functions, parameters and variables
gr.Parallel(model1, model2, model3).launch()

import gradio as gr
from gradio import inputs
from gradio.inputs import Textbox
from gradio import outputs
from transformers import pipeline

title = "Next Sentence Generator"
description = "Try this text generator!"
examples = [
   ["Zoe Kwan is a 20-year old singer and songwriter who has taken Hong Kong’s music scene by storm."],
   ["Zoe’s big break came when the godfather of Cantopop Sam Hui stumbled upon a YouTube video of Zoe singing."]
]
generator2 = gr.Interface.load("huggingface/EleutherAI/gpt-neo-2.7B")
generator3 = gr.Interface.load("huggingface/EleutherAI/gpt-j-6B")
generator1 = gr.Interface.load("huggingface/gpt2-large")

gr.Parallel(generator1, generator2, generator3, inputs=gr.inputs.Textbox(lines=5, label="Enter a sentence to get another sentence."), title=title, description=description, examples=examples).launch(share=False, enable_queue=True)

import gradio as gr

api = gr.Interface.load("huggingface/EleutherAI/gpt-j-6B")


def complete_with_gpt(text):
    # Use the last 50 characters of the text as context
    return text[:-50] + api(text[-50:])


with gr.Blocks() as demo:
    with gr.Row():
        textbox = gr.Textbox(placeholder="Type here and press enter...", lines=8)
        with gr.Column():
            btn = gr.Button("Generate")

    btn.click(complete_with_gpt, textbox, textbox)

demo.launch()
