import gradio as gr
import numpy as np
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LogisticRegression
from sklearn.pipeline import Pipeline
from sklearn.metrics import accuracy_score
import time
import paho.mqtt.client as mqtt

df = pd.read_csv("./Churn_Modelling.csv")
df.drop(["RowNumber","CustomerId","Surname"], axis=1, inplace=True)
df.head()

df.Balance.plot(kind="hist", figsize=(10,6))
df.Balance = np.where(df.Balance==0, 0, 1)
df.Balance.value_counts()
df.Age.plot(kind="hist", figsize=(10,6))

X = df.drop(["Exited","Geography","Gender"], axis=1)
y = df["Exited"]
X_train, X_test, y_train, y_test = train_test_split(X, y, random_state=42)

pl = Pipeline([
    ("scale", StandardScaler()),
    ("logreg", LogisticRegression())
])
pl.fit(X_train, y_train)
y_train_pred = pl.predict(X_train)
y_test_pred = pl.predict(X_test)

def sentence_builder(credit, age, tenure, balance, nb_prods, has_card, active, est_salary):
    data = [{
        "CreditScore": credit,
        "Age": age,
        "Tenure": tenure,
        "Balance": balance,
        "NumOfProducts": nb_prods,
        "HasCrCard": has_card,
        "IsActiveMember": active,
        "EstimatedSalary": est_salary,
    }]
    df = pd.json_normalize(data)
    res = bool(pl.predict(df)[0])
    return 'User will stay' if res else 'User will exit'

iface = gr.Interface(
    sentence_builder,
    [
        gr.inputs.Slider(0, 10000, label='credit'),
        gr.inputs.Slider(0, 100, label='age'),
        gr.inputs.Slider(0, 10, label='tenure'),
        gr.inputs.Slider(0, 10000, label='balance'),
        gr.inputs.Slider(0, 10, label='number of products'),
        gr.inputs.Checkbox(label="credit card"),
        gr.inputs.Checkbox(label="active"),
        gr.inputs.Slider(0, 200000, label='estimated salary'),
    ],
    "text",
    examples=[
        [619, 42, 2, 0, 1, 1, 1, 101348], # Returns False 0 
        [608, 41, 1, 83807, 1, 0, 1, 112542], # Returns True 1
    ],
)
iface.launch()
