import gradio as gr
import numpy as np
import pandas as pd
from tensorflow import keras

model = keras.models.load_model('model.h5')
classes = ['Mild_Demented', 'Moderate_Demented', 'Non_Demented', 'Very_Mild_Demented']

def analyse(image):
  data = image.reshape((1, 128, 128, 3))
  predict = model.predict(data)[0]
  return classes[np.argmax(predict)]

iface = gr.Interface(
    analyse,
    gr.inputs.Image(shape=(128,128)),
    "text",
    examples=['non.jpg', 'moderate.jpg', 'mild.jpg', 'verymild.jpg'],
)
iface.launch()