import gradio as gr
import cv2
from cv2 import dnn_superres
import sys
from os.path import exists

def upscale(image):
    # increase the size of the picture with a factor of 3
    factor = 2

    # Create an SR object
    sr = dnn_superres.DnnSuperResImpl_create()

    # Read image
    # image = cv2.imread(FILE_PATH)

    # Read the desired model
    path = "models/FSRCNN_x" + str(factor) + ".pb"
    sr.readModel(path)

    # Set the desired model and scale to get correct pre- and post-processing
    sr.setModel("fsrcnn", factor)

    # Upscale the image
    result = sr.upsample(image)

    # Save the image
    # cv2.imwrite("./upscaled.png", result)
    return result

iface = gr.Interface(
    upscale,
    gr.inputs.Image(shape=(128,128)),
    "text"
)
iface.launch()
