import cv2
import numpy as np
import socket
import sys
import pickle
import struct
import pygame

# Initialize pygame mixer
pygame.mixer.init()

# Set up dictionary of label-sound pairs
label_sound_dict = {
    "person": "a.mp3",
    "cell_phone": "b.mp3",
}

cap = cv2.VideoCapture(0)
clientsocket = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
clientsocket.connect(('localhost',8089))

# Initialize variables for label detection
label_count = 0
current_label = None

while True:
    ret, frame = cap.read()
    # Serialize frame
    data = pickle.dumps(frame)

    # Send message length first
    message_size = struct.pack("L", len(data)) ### CHANGED

    # Then data
    clientsocket.sendall(message_size + data)

    # Receive response from server
    response = clientsocket.recv(1024)
    decoded_response = response.decode()
    print(decoded_response)

    # Check if response is a label we care about
    if "[Scarecrow]: " in decoded_response:
        label = decoded_response.split("[Scarecrow]: ")[1]
        if label in label_sound_dict:
            if label != current_label:
                # Reset label count if new label detected
                current_label = label
                label_count = 1
            else:
                # Increment label count if same label detected
                label_count += 1
                if label_count >= 5: # play sound if label detected 5 times in a row
                    sound_file = label_sound_dict[label]
                    sound = pygame.mixer.Sound(sound_file)
                    sound.play()
                    label_count = 0
        else:
            current_label = None
            label_count = 0
