from tensorflow import keras
import streamlit as st
import altair as alt
import plotly.express as px

import pandas as pd
import numpy as np
from datetime import datetime


import joblib

from google.cloud import storage
from tempfile import TemporaryFile
from csv import writer
from datetime import datetime
import os
from dotenv import load_dotenv
from nltk.stem import PorterStemmer
from nltk.corpus import stopwords
import re
from tensorflow import keras
import numpy as np
import pandas as pd

from tensorflow.keras.preprocessing.sequence import pad_sequences
import nltk
from tensorflow.keras.preprocessing.text import one_hot


import re
from nltk.corpus import stopwords
from nltk.stem import PorterStemmer

import pickle
pkl_file = open('m_lb.pkl', 'rb')
le_departure = pickle.load(pkl_file)
pkl_file.close()
model = keras.models.load_model('m_odel.h5')
nltk.download('stopwords')
stopwords = set(nltk.corpus.stopwords.words('english'))
vocabSize = 11000
max_len = 1160
load_dotenv()

emotions_emoji_dict = { "anger":"😠",
					    "disgust":"🤮",
					    "fear":"😨😱",
						"happy":"🤗",
						"joy":"😂",
						"neutral":"😐",
						"sad":"😔", 
						"sadness":"😔",
						"shame":"😳",
						"surprise":"😮"
					}


def predict_emotions(sentence):
    sentence = sentence_cleaning(sentence)
    result = le_departure.inverse_transform(
        np.argmax(model.predict(sentence), axis=-1))[0]
    proba = np.max(model.predict(sentence))
    print()

    return result, proba, get_all_result(model.predict(sentence))


def get_all_result(prediction):
    dict = {}
    for element in prediction:
        for i in range(0, len(element)):
            dict[element[i]] = le_departure.inverse_transform([i])[0]
    return dict


def sentence_cleaning(sentence):
    """Pre-processing sentence for prediction"""
    stemmer = PorterStemmer()
    corpus = []
    text = re.sub("[^a-zA-Z]", " ", sentence)
    text = text.lower()
    text = text.split()
    text = [stemmer.stem(word) for word in text if word not in stopwords]
    text = " ".join(text)
    corpus.append(text)
    one_hot_word = [one_hot(input_text=word, n=vocabSize) for word in corpus]
    pad = pad_sequences(sequences=one_hot_word, maxlen=max_len, padding='pre')
    return pad


def main():
    st.title("🤮😨😱Emotion Classifier😂😳😮")
    menu = ["Home", "Monitor"]
    choice = st.sidebar.selectbox("Menu", menu)
    if choice == "Home":
        st.subheader("Home-Emotion In Text")

        with st.form(key='emotion_clf_form'):
            raw_text = st.text_area("Type Here")
            submit_text = st.form_submit_button(label='Submit')

        if submit_text:
            col1, col2 = st.columns(2)
            

            res, proba, total_result = predict_emotions(raw_text)

            with col1:
                st.success("Original Text")
                st.write(raw_text)

                st.success("Prediction")
                st.write("{}:{}".format(res, emotions_emoji_dict[res]))
                st.write("Confidence:{}".format(proba))
                
            with col2:
                source = pd.DataFrame({'Proba': list(total_result.keys()), 'Emotion': list(total_result.values())})

                fig = alt.Chart(source).mark_bar().encode(x='Emotion',y='Proba',color='Emotion')
                st.altair_chart(fig,use_container_width=True)
                

    else:
        st.subheader("About")


if __name__ == '__main__':
    main()
