import streamlit as st
import pandas as pd
import sklearn
import pickle

loaded_model = pickle.load(open("finalized_model.sav", 'rb'))


def main():
    st.image('img.jpg')
    st.title("⚙️🔩 Engine prediction ⚙️🔩")
    st.warning("Our Machine Learning algorithm predicts whether the elements of a machine work consistently\n\n")

    with st.form(key='columns_in_form'):
        c1, c2, c3 = st.columns(3)
        with c1:
            airTemperature = st.slider("Air temperature [K]", 0, 1500, 750)
        with c2:
            processTemperatire = st.slider(
                "Process temperature [K]", 0, 1500, 750)
        with c3:
            rotationSpeed = st.slider(
                "Rotational speed [rpm]", 0, 1500, 750)
            submitButton1 = st.form_submit_button(label='Save')
    with st.form(key='columns_in_form2'):
        c1, c2, c3, c4 = st.columns(4)
        with c1:
            toolWear = st.slider("Tool wear [min]", 0, 1500, 750)
        with c2:
            typeL = st.select_slider('Type_L', options=[0, 1])
        with c3:
            typeM = st.select_slider('Type_M', options=[0, 1])
        with c4:
            torqueNm = st.slider('Torque [Nm]', 0,300,150)
            submitButton2 = st.form_submit_button(label='Calculate')
    if (submitButton2):
        d = {'Air temperature [K]': airTemperature, 'Process temperature [K]': processTemperatire,
             'Rotational speed [rpm]': rotationSpeed, "Torque [Nm]": torqueNm, "Tool wear [min]": toolWear, "Type_L": typeL, "Type_M": typeM}
        ser = pd.Series(data=d, index=['Air temperature [K]', 'Process temperature [K]',
                        'Rotational speed [rpm]', 'Torque [Nm]', 'Tool wear [min]', 'Type_L', 'Type_M'])
        
        res = loaded_model.predict([ser])
        if (res[0] == 0):
            st.success("The machine is in good condition")
        else:
            st.error("The machine seems to have problems")



if __name__ == '__main__':
    main()
