import streamlit as st
import cv2
import numpy as np
import moviepy.editor as moviepy

st.set_page_config(
    layout="wide"
)
st.title("PENDETEKSI KENDARAAN")
st.header("Sistem Pendeteksi Objek Yang Melintas Pada Jalan Raya")

min_width_rect = 80
min_height_rect = 80
count_line_position = 550
algo = cv2.bgsegm.createBackgroundSubtractorMOG()
detect = []
offset = 8
counter = 0

def center_point(x, y, w, h):
    x1 = int(w/2)
    y1 = int(h/2)
    cx = x+x1
    cy = y+y1
    return cx,cy

video_data = st.file_uploader("Masukkan Video", ['mp4'])
temp_file_to_save = './temp_file_1.mp4'
temp_file_result  = './temp_file_2.mp4'
temp_file_detect = './temp_file_3.mp4'

def write_bytesio_to_file(filename, bytesio):
    with open(filename, "wb") as outfile:
        outfile.write(bytesio.getbuffer())

with st.spinner("Loading..."):
    if video_data:
        write_bytesio_to_file(temp_file_to_save, video_data)

        cap = cv2.VideoCapture(temp_file_to_save)

        width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
        height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
        frame_fps = cap.get(cv2.CAP_PROP_FPS)
        st.write(width, height, frame_fps)
        
        fourcc_mp4 = cv2.VideoWriter_fourcc(*'mp4v')
        out_mp4 = cv2.VideoWriter(temp_file_result, fourcc_mp4, frame_fps, (width, height),isColor = True)
        out_mp4_2 = cv2.VideoWriter(temp_file_detect, fourcc_mp4, frame_fps, (width, height),isColor = False)
    
        while True:
            ret,frame1 = cap.read()
            if not ret: break
            grey = cv2.cvtColor(frame1, cv2.COLOR_BGR2GRAY)
            blur = cv2.GaussianBlur(grey, (3, 3), 5)
            img_sub = algo.apply(blur)
            dilat = cv2.dilate(img_sub, np.ones((5, 5)))
            kernel = cv2.getStructuringElement(cv2.MORPH_ELLIPSE, (5, 5))
            dilatada = cv2.morphologyEx(dilat, cv2.MORPH_CLOSE, kernel)
            dilatada = cv2.morphologyEx(dilatada, cv2.MORPH_CLOSE, kernel)
            counterShape, h = cv2.findContours(dilatada, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)
            
            cv2.line(frame1, (25, count_line_position), (1250, count_line_position), (0, 0, 0), 4)

            for (i, c) in enumerate(counterShape) :
                (x, y, w, h) = cv2.boundingRect(c)
                validate_counter = (w>= min_width_rect) and (h>= min_height_rect)
                if not validate_counter :
                    continue

                cv2.rectangle(frame1, (x, y), (x+w, y+h), (0, 0, 255), 2)

                center = center_point(x, y, w, h)
                detect.append(center)
                cv2.circle(frame1, center, 4, (0, 255, 0), -1)

                for (x, y) in detect :
                    if y<(count_line_position+offset) and y>(count_line_position-offset) :
                        counter += 1
                        cv2.line(frame1, (25, count_line_position), (1250, count_line_position), (255, 255, 255), 4)
                        print("Jumlah Kendaraan : " + str(counter))

                    detect.remove((x,y))
            cv2.putText(frame1,"Jumlah Kendaraan : " + str(counter), (450, 70), cv2.FONT_HERSHEY_SIMPLEX, 2, (0, 0, 255), 5)
            out_mp4.write(frame1)
            out_mp4_2.write(dilatada)

        out_mp4.release()
        out_mp4_2.release()
        cap.release()

        convertedVideo = "./resulth264.mp4"
        detectedVideo = "./detectorh264.mp4"
        clip1 = moviepy.VideoFileClip(temp_file_detect)
        clip1.write_videofile(detectedVideo)
        clip = moviepy.VideoFileClip(temp_file_result)
        clip.write_videofile(convertedVideo)

        st.success("Berhasil Terdeteksi!")
        col1,col2,col3 = st.columns(3)
        col1.header("Video Asli")
        col1.video(temp_file_to_save)
        col2.header("Pendeteksi")
        col2.video(detectedVideo)
        col3.header("Hasil")
        col3.video(convertedVideo)
