from PyPDF2 import PdfReader
from langchain.embeddings.openai import OpenAIEmbeddings
from langchain.text_splitter import CharacterTextSplitter
from langchain.vectorstores import ElasticVectorSearch, Pinecone, Weaviate, FAISS
from langchain.chains.question_answering import load_qa_chain
from langchain.llms import OpenAI
import gradio as gr

import os



embeddings = OpenAIEmbeddings(openai_api_key=os.environ['OPENAI_API_KEY'])
docsearch = FAISS.load_local(folder_path = 'chanakyaNeeti',embeddings=embeddings)

chain = load_qa_chain(OpenAI(openai_api_key=os.environ['OPENAI_API_KEY']), chain_type="stuff")

def learn_from_chanakya_neeti(chat_history,query):
  greetings = ['hi', 'hello', 'hey', 'good morning', 'good afternoon', 'good evening', 'greetings', 'salutations', 'yo', 'howdy', 'hola', 'bonjour', 'konnichiwa', 'ni hao', 'ciao', 'salaam', 'shalom', 'namaste']
  if query.lower() in greetings:
      result = f"Hello!I am here to help with your question from Chanakya Neeti today."
  elif query.lower() in ["what are you?","who are you?"]:
      result = f'I am an AI chatbot available to assist you with any inquiries you may have about Chanakya Neeti.'
  else:
      docs = docsearch.similarity_search(query)
      result =  result if "i don’t know" not in (result:=chain.run(input_documents=docs, question=query)).lower().strip() else "Please only ask questions from chanakya neeti."
    
  return chat_history + [(query,result)]

with gr.Blocks() as demo:
  gr.HTML(value="""<h1 style="text-align: center;text-decoration: underline">Chankya Neeti</h1>""")
  gr.HTML(value="""<p style="font-style: italic;">Chanakya Neeti is the essence of various scriptures Chanakya carefully studied to come up with a code of conduct that will benefit all mankind. It is a book written by Chanakya, a great scholar, to simplify complicated scriptures and provide a practical application of moral codes and ideal conduct.<p>""")
  chatbot = gr.Chatbot()
  textbox = gr.Textbox(label="Ask your question.",placeholder="How can one build a strong and successful team?")

  textbox.submit(fn=learn_from_chanakya_neeti,inputs=[chatbot,textbox],outputs=[chatbot])


demo.launch(debug=True)