import os
import streamlit as st
from langchain.chains import LLMChain
from langchain.prompts import PromptTemplate
from langchain.llms import OpenAI

api_key = os.getenv("OPENAI_API_KEY")

llm = OpenAI(temperature=0.6, api_key=api_key)

prompt_template_name = PromptTemplate(
    input_variables=['symptoms'],
    template="What Diseases are associated with {symptoms}? Mention one disease only by its name."
)
prompt_template_coping_strategies = PromptTemplate(
    input_variables=['response'],
    template="What are coping strategies for dealing with {response}? Write 3 strategies only."
)
prompt_template_books = PromptTemplate(
    input_variables=['disease'],
    template="What are books one should read probably having {disease} to know more about? Write 3 books only."
)

chain_name = LLMChain(llm=llm, prompt=prompt_template_name)
chain_coping_strategies = LLMChain(llm=llm, prompt=prompt_template_coping_strategies)
chain_books = LLMChain(llm=llm, prompt=prompt_template_books)

def get_disease_and_strategies(symptoms):
    disease_response = chain_name.run(symptoms)
    disease = disease_response
    
    coping_strategies_response = chain_coping_strategies.run(disease)
    coping_strategies = coping_strategies_response
    
    books_response = chain_books.run(disease)
    books = books_response

    return {
        'Disease': disease,
        'Coping Strategies': coping_strategies,
        'Books': books
    }

def main():
    st.title("Mental Health Classifier and Dashboard Generator")
    st.write("Enter your symptoms and get health information:")

    user_input = st.text_input("Enter Symptoms:")

    if st.button("Submit"):
        if user_input.strip().lower() == 'exit':
            st.write("Thank you for using the Health Chatbot. Goodbye!")
        else:
            output = get_disease_and_strategies(user_input)
            response = f"Health Information:\n\nDisease: {output['Disease']}\n\nCoping Strategies: {output['Coping Strategies']}\n\nBooks: {output['Books']}"
            st.write(response)

if __name__ == '__main__':
    main()
    
