import streamlit as st
import numpy as np
import cv2
from io import BytesIO
from streamlit_webrtc import webrtc_streamer
from turn import get_ice_servers
import av

def create_blake_image(input_image):
    # Read the image from the BytesIO object
    img = cv2.imdecode(np.frombuffer(input_image.read(), np.uint8), -1)
    
    # Get the shape of the original image
    height, width, _ = img.shape
    
    # Create a circular mask with the same shape
    mask = np.zeros((height, width), dtype=np.uint8)
    circle_center = (width // 2, height // 2)
    circle_radius = min(width, height) // 2
    cv2.circle(mask, circle_center, circle_radius, 255, thickness=-1)
    
    # Apply the mask to the original image
    result = cv2.bitwise_and(img, img, mask=mask)
    
    return result



# Continue with the rest of your processing

class VideoProcessor:
    num_bins = 256
    video_stopped = False
    
    def recv(self, frame):
        frm = frame.to_ndarray(format="bgr24")
        # Print the format and shape of the original image
        text = str(frm.dtype)
        cv2.putText(frm, text, (20, 50), cv2.FONT_HERSHEY_SIMPLEX, 2, (0, 255, 0))
        frm = cv2.flip(frm,1)
        modified_frm  = create_blake_image(frm)
        text2 = str(frm.shape)
        cv2.putText(modified_frm, text2, (30, 70), cv2.FONT_HERSHEY_SIMPLEX, 2, (0, 255, 0))
        # Print the format and shape of the original image
        st.write(f"Original Image Format: {modified_frm.dtype}")
        st.write(f"Original Image Shape: {modified_frm.shape}")

        return av.VideoFrame.from_ndarray(modified_frm , format='bgr24')
# Inside your Streamlit app

st.title("التركيز على وسط الشاشة")

webrtc_streamer(key="example", video_processor_factory=VideoProcessor,media_stream_constraints={"video": True, "audio": False},rtc_configuration={"iceServers": get_ice_servers()},)
