from torch import nn
import gradio as gr
import torch.nn as nn
import torch
import numpy as np
import matplotlib.pyplot as plt
from torch.autograd import Variable
from torch.utils.data import DataLoader
import torch.nn.functional as F
import tensorflow as tf
from tensorflow import Tensor
from tensorflow.keras.layers import Input, Conv2D, ReLU, BatchNormalization,\
                                    Add, AveragePooling2D, Flatten, Dense
from tensorflow.keras.models import Model
from tensorflow.keras import layers
torch.manual_seed(0)
physical_devices = tf.config.list_physical_devices('GPU') 
for device in physical_devices:
    tf.config.experimental.set_memory_growth(device, True)

def weights_init_normal(m):
    classname = m.__class__.__name__
    if classname.find("Conv") != -1:
        torch.nn.init.normal_(m.weight.data, 0.0, 0.02)
    elif classname.find("BatchNorm2d") != -1:
        torch.nn.init.normal_(m.weight.data, 1.0, 0.02)
        torch.nn.init.constant_(m.bias.data, 0.0)

class UNetDown(nn.Module):
    def __init__(self, in_size, out_size, normalize=True, dropout=0.0):
        super(UNetDown, self).__init__()
        layers = [nn.Conv2d(in_size, out_size, 4, 2, 1, bias=False)]
        if normalize:
            layers.append(nn.InstanceNorm2d(out_size))
        layers.append(nn.LeakyReLU(0.2))
        if dropout:
            layers.append(nn.Dropout(dropout))
        self.model = nn.Sequential(*layers)

    def forward(self, x):
        return self.model(x)


class UNetUp(nn.Module):
    def __init__(self, in_size, out_size, dropout=0.0):
        super(UNetUp, self).__init__()
        layers = [
            nn.ConvTranspose2d(in_size, out_size, 4, 2, 1, bias=False),
            nn.InstanceNorm2d(out_size),
            nn.ReLU(inplace=True),
        ]
        if dropout:
            layers.append(nn.Dropout(dropout))

        self.model = nn.Sequential(*layers)

    def forward(self, x, skip_input):
        x = self.model(x)
        x = torch.cat((x, skip_input), 1)

        return x


class GeneratorUNet(nn.Module):
    def __init__(self, in_channels=1, out_channels=1):
        super(GeneratorUNet, self).__init__()

        self.down1 = UNetDown(in_channels, 64, normalize=False)
        self.down2 = UNetDown(64, 128)
        self.down3 = UNetDown(128, 256,dropout=0.5)
        self.down4 = UNetDown(256, 512, normalize=False,dropout=0.5)
        self.down5 = UNetDown(512, 512, normalize=False,dropout=0.5)
        self.up1 = UNetUp(512, 512, dropout=0.5)
        self.up2 = UNetUp(1024, 256, dropout=0.5)
        self.up3 = UNetUp(512, 128)
        self.up4 = UNetUp(256, 64)
        self.final = nn.Sequential(
            nn.Upsample(scale_factor=2),
            nn.ZeroPad2d((1, 0, 1, 0)),
            nn.Conv2d(128, out_channels, 4, padding=1),
            nn.Tanh(),
        )

    def forward(self, x):
        # U-Net generator with skip connections from encoder to decoder
        d1 = self.down1(x)
        d2 = self.down2(d1)
        d3 = self.down3(d2)
        d4 = self.down4(d3)
        d5 = self.down5(d4)
        u1 = self.up1(d5, d4)
        u2 = self.up2(u1, d3)
        u3 = self.up3(u2, d2)
        u4 = self.up4(u3, d1)
        u5 = self.final(u4)
        return u5



import tensorflow as tf
from tensorflow import Tensor
from tensorflow.keras.layers import Input, Conv2D, ReLU, BatchNormalization,\
                                    Add, AveragePooling2D, Flatten, Dense
from tensorflow.keras.models import Model

from tensorflow.keras import layers
tf.random.set_seed(123)
class Patches(tf.keras.layers.Layer):
    def __init__(self, patch_size):
        super(Patches, self).__init__()
        self.patch_size = patch_size

    def call(self, images):
        batch_size = tf.shape(images)[0]
        patches = tf.image.extract_patches(
            images=images,
            sizes=[1, self.patch_size, self.patch_size, 1],
            strides=[1, self.patch_size, self.patch_size, 1],
            rates=[1, 1, 1, 1],
            padding="SAME",
        )
        patch_dims = patches.shape[-1]
        patches = tf.reshape(patches, [batch_size, -1, patch_dims])
        return patches

    def get_config(self):
        config = super(Patches, self).get_config()
        config.update({
            'patch_size': self.patch_size
        })
        return config
    #def get_config(self):
    #    return {"patch_size": self.patch_size}


class PatchEncoder(tf.keras.layers.Layer):
    def __init__(self, num_patches, projection_dim):
        super(PatchEncoder, self).__init__()
        self.num_patches = num_patches
        self.projection = layers.Dense(units=projection_dim)
        self.position_embedding = layers.Embedding(
            input_dim=num_patches, output_dim=projection_dim
        )

    def call(self, patch):
        positions = tf.range(start=0, limit=self.num_patches, delta=1)
        encoded = self.projection(patch) + self.position_embedding(positions)
        return encoded
    
    def get_config(self):
        config = super(PatchEncoder, self).get_config()
        config.update({
            'num_patches': self.num_patches,
            'projection': self.projection,
            'position_embedding': self.position_embedding, 

        })
        return config



class TransformerBlock(tf.keras.layers.Layer):
    def __init__(self, embed_dim, num_heads, ff_dim, rate=0.1):
        super(TransformerBlock, self).__init__()
        self.att = layers.MultiHeadAttention(num_heads=num_heads, key_dim=embed_dim)
        self.ffn = tf.keras.Sequential(
            [layers.Dense(ff_dim, activation="relu"), layers.Dense(embed_dim),]
        )
        self.layernorm1 = layers.LayerNormalization(epsilon=1e-6)
        self.layernorm2 = layers.LayerNormalization(epsilon=1e-6)
        self.dropout1 = layers.Dropout(rate)
        self.dropout2 = layers.Dropout(rate)

    def call(self, inputs, training):
        attn_output = self.att(inputs, inputs)
        attn_output = self.dropout1(attn_output, training=training)
        out1 = self.layernorm1(inputs + attn_output)
        ffn_output = self.ffn(out1)
        ffn_output = self.dropout2(ffn_output, training=training)
        return self.layernorm2(out1 + ffn_output)
    
    def get_config(self):
        config = super(TransformerBlock, self).get_config()
        config.update({
            'att': self.att,
            'ffn': self.ffn,
            'layernorm1': self.layernorm1,
            'layernorm2':self.layernorm2,
            'dropout1':self.dropout1,
            'dropout2':self.dropout2,
        })
        return config

def relu_bn(inputs: Tensor) -> Tensor:
    relu = ReLU()(inputs)
    bn = BatchNormalization()(relu)
    return bn


def residual_block(x: Tensor, downsample: bool, filters: int, kernel_size: int = 3) -> Tensor:
    y = Conv2D(kernel_size=kernel_size,
               strides= (1 if not downsample else 2),
               filters=filters,
               padding="same")(x)
    y = relu_bn(y)
    y = Conv2D(kernel_size=kernel_size,
               strides=1,
               filters=filters,
               padding="same")(y)

    if downsample:
        x = Conv2D(kernel_size=1,
                   strides=2,
                   filters=filters,
                   padding="same")(x)
    out = Add()([x, y])
    out = relu_bn(out)
    return out



def Generator(input_shape, 
              patch_size, 
              num_patches, 
              projection_dim, 
              num_heads, 
              ff_dim):

    inputs = layers.Input(shape=(32, 32, 1))

    patches = Patches(patch_size)(inputs)
    print("patches:",patches.shape)
    encoded_patches = PatchEncoder(num_patches, projection_dim)(patches)
    print("encoded patches:",encoded_patches.shape)
    x = TransformerBlock(16, num_heads, ff_dim)(encoded_patches)
    print("first transformer block:",x.shape)
    x = TransformerBlock(16, num_heads, ff_dim)(x)
    #x = TransformerBlock(16, num_heads, ff_dim)(x)
    #x = TransformerBlock(16, num_heads, ff_dim)(x)
    print("Before reshape:",x.shape)
    x = layers.Reshape((4, 4, x.shape[1]))(x)
    print("After reshape: ",x.shape)
    x = layers.Conv2DTranspose(32, (5, 5), strides=(2, 2), padding='same', use_bias=False)(x)
    x = layers.BatchNormalization()(x)
    x = layers.LeakyReLU()(x)
    print("First conv2dtrans:",x.shape)
    x = residual_block(x, downsample=False, filters=32)

    x = layers.Conv2DTranspose(16, (5, 5), strides=(2, 2), padding='same', use_bias=False)(x)
    x = layers.BatchNormalization()(x)
    x = layers.LeakyReLU()(x)
    print("First conv2dtrans:",x.shape)
    x = residual_block(x, downsample=False, filters=16)
    x = layers.Conv2DTranspose(8, (5, 5), strides=(2, 2), padding='same', use_bias=False)(x)
    x = layers.BatchNormalization()(x)
    x = layers.LeakyReLU()(x)
    print("First conv2dtrans:",x.shape)
    x = residual_block(x, downsample=False, filters=8)

    #x = layers.Conv2DTranspose(16, (5, 5), strides=(2, 2), padding='same', use_bias=False)(x)
    #x = layers.BatchNormalization()(x)
    #x = layers.LeakyReLU()(x)
    #print("First conv2dtrans:",x.shape)
    #x = residual_block(x, downsample=False, filters=16)

    #x = layers.Conv2DTranspose(32, (5, 5), strides=(4, 4), padding='same', use_bias=False)(x)
    #x = layers.BatchNormalization()(x)
    #x = layers.LeakyReLU()(x)
    #print("First conv2dtrans:",x.shape)
    #x = residual_block(x, downsample=False, filters=32)

    x = layers.Conv2D(1, (3, 3), strides=(1, 1), padding='same', use_bias=False, activation='tanh')(x)
    print("Final shape:- ",x.shape)
    return tf.keras.Model(inputs=inputs, outputs=x)


def transform_img(t,b,l,r,mode):
    T = np.empty((32,32))
    T.fill(0)
    T[31:, :] = t
    T[:1, :] = b
    T[:, 31:] = r
    T[:, :1] = l
    new_t = []
    new_t.append(T)
    new_t.append(T)
    new_t = np.array(new_t)
    valid_cond_norm = np.zeros_like(new_t)
    for i in range(len(new_t)):
        valid_cond_norm[i] = ((new_t[i]/(new_t[i].max()/2))-1.)
    valid_cond_norm1 = valid_cond_norm.reshape((valid_cond_norm.shape[0],valid_cond_norm.shape[1],valid_cond_norm.shape[2],1)) 
    valid_cond_norm2 = np.transpose(valid_cond_norm1,(0,3,2,1)) 
    valid_cond_norm = torch.Tensor(valid_cond_norm2)
    return valid_cond_norm

def transform_img_tf(t,b,l,r):
    T = np.empty((32,32))
    T.fill(0)
    T[31:, :] = t
    T[:1, :] = b
    T[:, 31:] = r
    T[:, :1] = l
    new_t = []
    new_t.append(T)
    new_t.append(T)
    new_t = np.array(new_t)
    valid_cond_norm = np.zeros_like(new_t)
    for i in range(len(new_t)):
        valid_cond_norm[i] = ((new_t[i]/(new_t[i].max()/2))-1.)
    valid_cond_norm1 = valid_cond_norm.reshape((valid_cond_norm.shape[0],valid_cond_norm.shape[1],valid_cond_norm.shape[2],1)) 
    valid_cond_norm1 = tf.constant(valid_cond_norm1,dtype=tf.float32)
    print(valid_cond_norm1.shape)
    dataset_valid = tf.data.Dataset.from_tensor_slices((valid_cond_norm1))
    dataset_valid = dataset_valid.batch(1)
    return dataset_valid

#cuda = True if torch.cuda.is_available() else False
#Tensor = torch.cuda.FloatTensor if cuda else torch.FloatTensor
def predict(text,top,bottom,right,left):
    
    if text == 'Generator':
        x = transform_img(top,bottom,right,left,'gen')
        model = GeneratorUNet()
        model.load_state_dict(torch.load("./generator_499.pth", map_location=torch.device('cpu'))) # Use 'cuda' if you have a GPU available
        #if cuda:
        #    model = model.cuda()
        real_A1 = Variable(x.type(torch.FloatTensor))
        fake_B1 = model(real_A1)
        fake1 = fake_B1.detach().cpu().permute(0,3, 2, 1)
        colourMap = plt.cm.jet 
        X, Y = np.meshgrid(np.arange(0, 32), np.arange(0, 32))
        fig, ax = plt.subplots(1, 1)
        ax.contourf(X, Y, fake1[0,:,:,0], cmap=colourMap)
        return fig
    if text =='Transformer':
        x = transform_img_tf(top,bottom,right,left)
        #print(x.shape)
        LAMBDA = 100
        IMG_WIDTH = 32
        IMG_HEIGHT = 32
        patch_size = 4
        num_patches = (IMG_HEIGHT // patch_size) ** 2
        projection_dim = 16
        embed_dim = 16
        num_heads = 16 
        ff_dim = 8
        input_shape = (32, 32, 1)
        generator1 = Generator(input_shape, patch_size, num_patches, projection_dim, num_heads, ff_dim)
        generator1.load_weights('./epoch_149.h5')
        for img in x.take(2):
            print(img)
            #print("Image:-",img.shape)
            pred = generator1(img)
        print(pred.shape)
        pred = pred.numpy()
        pred = pred[0,:,:,0]
        colourMap = plt.cm.jet 
        X, Y = np.meshgrid(np.arange(0, 32), np.arange(0, 32))
        fig, ax = plt.subplots(1, 1)
        ax.contourf(X, Y, pred, cmap=colourMap)
        return fig
gr.Interface(
    predict,
    inputs=[
        gr.Dropdown(["Generator", "Transformer"]),
        gr.Slider(0, 40, label='top', step=10),
        gr.Slider(40, 80, label='bottom', step=10),
        gr.Slider(80, 120, label='right', step=10),
        gr.Slider(120, 150, label='left', step=10),
    ],
    outputs=gr.Plot(),
    
).launch()
