import gradio as gr
import plotly.graph_objects as go

import numpy as np
from scipy.special import sph_harm


def simple_sph_plot(l, m):
    # Fix the input if invalid
    if abs(m) > l:
        m = 0

    resolution = 200

    # Pick uniform angles
    theta = np.linspace(0, np.pi, resolution)
    phi = np.linspace(0, 2 * np.pi, resolution)
    theta, phi = np.meshgrid(theta, phi)

    # The spherical harmonic function to plot
    Y_lm = sph_harm(m, l, phi, theta).real  # Original
    #if m == 0:
    #    Y_lm = sph_harm(m, l, phi, theta).real
    #elif m < 0:
    #    Y_lm = np.sqrt(2) * (-1)**m * sph_harm(-m, l, phi, theta).imag
    #else:
    #    Y_lm = np.sqrt(2) * (-1)**m * sph_harm(m, l, phi, theta).real

    # Convert to Cartesian coordinates
    x = np.sin(theta) * np.cos(phi) * np.abs(Y_lm)
    y = np.sin(theta) * np.sin(phi) * np.abs(Y_lm)
    z = np.cos(theta) * np.abs(Y_lm)

    surf = go.Surface(
        x=x, y=y, z=z, surfacecolor=Y_lm, colorscale="RdBu", showscale=False
    )

    fig = go.Figure(data=[surf])

    # Make axis invisible
    invisible_axis = dict(
        showbackground=False,
        showline=False,
        zeroline=False,
        showgrid=False,
        showticklabels=False,
        title="",
    )

    camera = {
        "up": {"x": 0, "y": 0, "z": 1},
        "center": {"x": 0, "y": 0, "z": 0},
        "eye": {"x": 1.25, "y": 1.25, "z": 1.25},
    }

    fig.update_layout(
        **{
            f"scene": {
                "xaxis": invisible_axis,
                "yaxis": invisible_axis,
                "zaxis": invisible_axis,
            },
            "scene_camera": camera,
        }
    )

    return fig


outputs = gr.Plot()
inputs = [
    gr.Number(value=1, minimum=0, info="Angular Momentum"),
    gr.Number(value=1, info="z-Component"),
]

iface = gr.Interface(fn=simple_sph_plot, inputs=inputs, outputs=outputs)

iface.launch()
