import gradio as gr
import torch

from transformers import AutoTokenizer, AutoModelForSeq2SeqLM

#"Google T5-base","Google MT5-small","Google Pegasus","Facebook Bart-large","Facebook DistilBART"
def summarize(inputs,model,summary_length):
  prefix = ""
  if model=="Google T5-base":
        tokenizer = AutoTokenizer.from_pretrained("Einmalumdiewelt/T5-Base_GNAD")
        model = AutoModelForSeq2SeqLM.from_pretrained("Einmalumdiewelt/T5-Base_GNAD")
        prefix = "summarize: "
  elif model=="Google Pegasus":
        tokenizer = AutoTokenizer.from_pretrained("Einmalumdiewelt/PegasusXSUM_GNAD")
        model = AutoModelForSeq2SeqLM.from_pretrained("Einmalumdiewelt/PegasusXSUM_GNAD")
  elif model=="Facebook Bart-large":
        tokenizer = AutoTokenizer.from_pretrained("Einmalumdiewelt/BART_large_CNN_GNAD")
        model = AutoModelForSeq2SeqLM.from_pretrained("Einmalumdiewelt/BART_large_CNN_GNAD")
  elif model=="Google MT5-small":
        tokenizer = AutoTokenizer.from_pretrained("Einmalumdiewelt/MT5_small_sum-de_GNAD")
        model = AutoModelForSeq2SeqLM.from_pretrained("Einmalumdiewelt/MT5_small_sum-de_GNAD")
        prefix = "summarize: "
  elif model=="Facebook DistilBART":
        tokenizer = AutoTokenizer.from_pretrained("Einmalumdiewelt/DistilBART_CNN_GNAD")
        model = AutoModelForSeq2SeqLM.from_pretrained("Einmalumdiewelt/DistilBART_CNN_GNAD")
  
  device = "cpu"
  #"cuda" if torch.cuda.is_available() else "CPU"
  model.to(device)
  
  
  #print(str(inputs))
  print(str(prefix)+str(inputs))
  
  #define model inputs          
  inputs = tokenizer(
        prefix + inputs,
        max_length=512,
        truncation=True,
        padding="max_length",
        return_tensors='pt').to(device)
  
           
  #generate preds
  if summary_length==25:
        # make sure models actually generate something
        preds = model.generate(**inputs,max_length=summary_length+5,min_length=summary_length-20)    
  else:
        preds = model.generate(**inputs,max_length=summary_length+25,min_length=summary_length-25)
  #we decode the predictions to store them
  decoded_predictions = tokenizer.batch_decode(preds, skip_special_tokens=True)
  #return 
  return decoded_predictions[0]

description = "Quickly summarize your German texts in a few sentences. \nOur algorithms were fine-tuned on high-quality German news articles and work best with a summarization length of about 75 tokens. Please note that inference can take up to 60 seconds, so feel free to look at some of the examples, first. All provided examples are out-of-sample texts from German news providers. They were not cherry-picked and reflect the real performance of our fine-tuned architectures."

title = "State-of-the-art German \ntext summarization."

examples = [
["Keine einzige Zelle unseres Körpers kommt ohne sie aus: Proteine sind essenzielle Bausteine lebender Organismen. Ihr Bauplan ist in der DNA festgelegt. Zu den Proteinen gehören die Bestandteile des Immunsystems, etwa Antikörper, genauso wie Hormone, etwa Insulin, oder Enzyme, die beispielsweise im Dünndarm Milchzucker spalten und Milch verträglich machen. Wie genau ein Protein im Körper wirkt, hängt nicht nur von der Reihenfolge der Atome ab, aus denen es besteht – sondern auch von seiner Struktur: Die langen Ketten von Aminosäuren, aus denen Proteine zusammengesetzt sind, verknäulen sich zu komplexen 3D-Strukturen. Und deren Entschlüsselung gilt oft als mühsam und zeitaufwendig; dabei kommt vor allem die Methode der Röntgenkristallstrukturanalyse zum Einsatz. Bereits Ende vergangenen Jahres hatten Forscherinnen und Forscher der britischen Firma DeepMind, einer Tochter der Google-Holding Alphabet, aber einen Erfolg bei einem neuartigen Ansatz vermeldet. Eine von ihnen entwickelte künstliche Intelligenz (KI) namens AlphaFold kann demnach die Strukturen von Molekülen präzise vorhersagen. Nun hat das Team um Kathryn Tunyasuvunakool, John Jumper und Demis Hassabis von DeepMind die Anwendung des Verfahrens in einem Fachartikel im Magazin »Nature«  vorgestellt. Entstanden ist eine frei zugängliche Datenbank, die viele Tausend Proteinstrukturen enthält. Diese sollen für Durchbrüche in der medizinischen Forschung genutzt werden, aber auch für die Pflanzenzucht – oder für die Entwicklung von Bakterien, die Plastik in der Umwelt zersetzen können. Abgedeckt ist dabei beinahe die komplette Menge aller 20.000 beim Menschen vorkommenden Proteine, das sogenannte Proteom, allerdings mit verschiedenen Genauigkeitsstufen. Dazu kommen Zehntausende weitere Proteine, die in anderen für die Forschung wichtigen Modellorganismen wie Mäusen, Fruchtfliegen oder Coli-Bakterien eine Rolle spielen. Die Kenntnis der Struktur ist so wichtig, weil sich auf diese Weise vorhersagen lässt, wie andere Moleküle an das Protein binden – also welche Wirkung ein bestimmter Stoff in der Praxis hat. »Wir glauben, dass es sich um das bisher vollständigste und genaueste Bild des menschlichen Proteoms handelt«, so Hassabis, der auch Chef von DeepMind ist. Seine Firma sei außerdem der Meinung, »dass diese Arbeit den bedeutendsten Beitrag darstellt, den Künstliche Intelligenz bisher zum Fortschritt des wissenschaftlichen Kenntnisstandes geleistet hat«.  »Das wird unser Verständnis darüber revolutionieren, wie Leben funktioniert«, sagt  Edith Heard vom Europäischen Laboratorium für Molekularbiologie (EMBL) in Heidelberg. »Die Anwendungsmöglichkeiten sind nur durch unsere Vorstellungskraft begrenzt.« Am EMBL wird die Datenbank der Proteinstrukturen in Zukunft betreut. Und Gira Bhabha, die sich an der New York University mit Zellbiologie beschäftigt, lobt  die Zeitersparnis für Projekte in verschiedensten Bereichen der Forschung: »Egal, ob Sie Neurowissenschaften oder Immunologie studieren – was auch immer Ihr Fachgebiet der Biologie ist – dies kann nützlich sein.« chs/jme","Google T5-base",75],
["Keine einzige Zelle unseres Körpers kommt ohne sie aus: Proteine sind essenzielle Bausteine lebender Organismen. Ihr Bauplan ist in der DNA festgelegt. Zu den Proteinen gehören die Bestandteile des Immunsystems, etwa Antikörper, genauso wie Hormone, etwa Insulin, oder Enzyme, die beispielsweise im Dünndarm Milchzucker spalten und Milch verträglich machen. Wie genau ein Protein im Körper wirkt, hängt nicht nur von der Reihenfolge der Atome ab, aus denen es besteht – sondern auch von seiner Struktur: Die langen Ketten von Aminosäuren, aus denen Proteine zusammengesetzt sind, verknäulen sich zu komplexen 3D-Strukturen. Und deren Entschlüsselung gilt oft als mühsam und zeitaufwendig; dabei kommt vor allem die Methode der Röntgenkristallstrukturanalyse zum Einsatz. Bereits Ende vergangenen Jahres hatten Forscherinnen und Forscher der britischen Firma DeepMind, einer Tochter der Google-Holding Alphabet, aber einen Erfolg bei einem neuartigen Ansatz vermeldet. Eine von ihnen entwickelte künstliche Intelligenz (KI) namens AlphaFold kann demnach die Strukturen von Molekülen präzise vorhersagen. Nun hat das Team um Kathryn Tunyasuvunakool, John Jumper und Demis Hassabis von DeepMind die Anwendung des Verfahrens in einem Fachartikel im Magazin »Nature«  vorgestellt. Entstanden ist eine frei zugängliche Datenbank, die viele Tausend Proteinstrukturen enthält. Diese sollen für Durchbrüche in der medizinischen Forschung genutzt werden, aber auch für die Pflanzenzucht – oder für die Entwicklung von Bakterien, die Plastik in der Umwelt zersetzen können. Abgedeckt ist dabei beinahe die komplette Menge aller 20.000 beim Menschen vorkommenden Proteine, das sogenannte Proteom, allerdings mit verschiedenen Genauigkeitsstufen. Dazu kommen Zehntausende weitere Proteine, die in anderen für die Forschung wichtigen Modellorganismen wie Mäusen, Fruchtfliegen oder Coli-Bakterien eine Rolle spielen. Die Kenntnis der Struktur ist so wichtig, weil sich auf diese Weise vorhersagen lässt, wie andere Moleküle an das Protein binden – also welche Wirkung ein bestimmter Stoff in der Praxis hat. »Wir glauben, dass es sich um das bisher vollständigste und genaueste Bild des menschlichen Proteoms handelt«, so Hassabis, der auch Chef von DeepMind ist. Seine Firma sei außerdem der Meinung, »dass diese Arbeit den bedeutendsten Beitrag darstellt, den Künstliche Intelligenz bisher zum Fortschritt des wissenschaftlichen Kenntnisstandes geleistet hat«.  »Das wird unser Verständnis darüber revolutionieren, wie Leben funktioniert«, sagt  Edith Heard vom Europäischen Laboratorium für Molekularbiologie (EMBL) in Heidelberg. »Die Anwendungsmöglichkeiten sind nur durch unsere Vorstellungskraft begrenzt.« Am EMBL wird die Datenbank der Proteinstrukturen in Zukunft betreut. Und Gira Bhabha, die sich an der New York University mit Zellbiologie beschäftigt, lobt  die Zeitersparnis für Projekte in verschiedensten Bereichen der Forschung: »Egal, ob Sie Neurowissenschaften oder Immunologie studieren – was auch immer Ihr Fachgebiet der Biologie ist – dies kann nützlich sein.« chs/jme","Google Pegasus",75],
["Keine einzige Zelle unseres Körpers kommt ohne sie aus: Proteine sind essenzielle Bausteine lebender Organismen. Ihr Bauplan ist in der DNA festgelegt. Zu den Proteinen gehören die Bestandteile des Immunsystems, etwa Antikörper, genauso wie Hormone, etwa Insulin, oder Enzyme, die beispielsweise im Dünndarm Milchzucker spalten und Milch verträglich machen. Wie genau ein Protein im Körper wirkt, hängt nicht nur von der Reihenfolge der Atome ab, aus denen es besteht – sondern auch von seiner Struktur: Die langen Ketten von Aminosäuren, aus denen Proteine zusammengesetzt sind, verknäulen sich zu komplexen 3D-Strukturen. Und deren Entschlüsselung gilt oft als mühsam und zeitaufwendig; dabei kommt vor allem die Methode der Röntgenkristallstrukturanalyse zum Einsatz. Bereits Ende vergangenen Jahres hatten Forscherinnen und Forscher der britischen Firma DeepMind, einer Tochter der Google-Holding Alphabet, aber einen Erfolg bei einem neuartigen Ansatz vermeldet. Eine von ihnen entwickelte künstliche Intelligenz (KI) namens AlphaFold kann demnach die Strukturen von Molekülen präzise vorhersagen. Nun hat das Team um Kathryn Tunyasuvunakool, John Jumper und Demis Hassabis von DeepMind die Anwendung des Verfahrens in einem Fachartikel im Magazin »Nature«  vorgestellt. Entstanden ist eine frei zugängliche Datenbank, die viele Tausend Proteinstrukturen enthält. Diese sollen für Durchbrüche in der medizinischen Forschung genutzt werden, aber auch für die Pflanzenzucht – oder für die Entwicklung von Bakterien, die Plastik in der Umwelt zersetzen können. Abgedeckt ist dabei beinahe die komplette Menge aller 20.000 beim Menschen vorkommenden Proteine, das sogenannte Proteom, allerdings mit verschiedenen Genauigkeitsstufen. Dazu kommen Zehntausende weitere Proteine, die in anderen für die Forschung wichtigen Modellorganismen wie Mäusen, Fruchtfliegen oder Coli-Bakterien eine Rolle spielen. Die Kenntnis der Struktur ist so wichtig, weil sich auf diese Weise vorhersagen lässt, wie andere Moleküle an das Protein binden – also welche Wirkung ein bestimmter Stoff in der Praxis hat. »Wir glauben, dass es sich um das bisher vollständigste und genaueste Bild des menschlichen Proteoms handelt«, so Hassabis, der auch Chef von DeepMind ist. Seine Firma sei außerdem der Meinung, »dass diese Arbeit den bedeutendsten Beitrag darstellt, den Künstliche Intelligenz bisher zum Fortschritt des wissenschaftlichen Kenntnisstandes geleistet hat«.  »Das wird unser Verständnis darüber revolutionieren, wie Leben funktioniert«, sagt  Edith Heard vom Europäischen Laboratorium für Molekularbiologie (EMBL) in Heidelberg. »Die Anwendungsmöglichkeiten sind nur durch unsere Vorstellungskraft begrenzt.« Am EMBL wird die Datenbank der Proteinstrukturen in Zukunft betreut. Und Gira Bhabha, die sich an der New York University mit Zellbiologie beschäftigt, lobt  die Zeitersparnis für Projekte in verschiedensten Bereichen der Forschung: »Egal, ob Sie Neurowissenschaften oder Immunologie studieren – was auch immer Ihr Fachgebiet der Biologie ist – dies kann nützlich sein.« chs/jme","Google MT5-small",75],
["Keine einzige Zelle unseres Körpers kommt ohne sie aus: Proteine sind essenzielle Bausteine lebender Organismen. Ihr Bauplan ist in der DNA festgelegt. Zu den Proteinen gehören die Bestandteile des Immunsystems, etwa Antikörper, genauso wie Hormone, etwa Insulin, oder Enzyme, die beispielsweise im Dünndarm Milchzucker spalten und Milch verträglich machen. Wie genau ein Protein im Körper wirkt, hängt nicht nur von der Reihenfolge der Atome ab, aus denen es besteht – sondern auch von seiner Struktur: Die langen Ketten von Aminosäuren, aus denen Proteine zusammengesetzt sind, verknäulen sich zu komplexen 3D-Strukturen. Und deren Entschlüsselung gilt oft als mühsam und zeitaufwendig; dabei kommt vor allem die Methode der Röntgenkristallstrukturanalyse zum Einsatz. Bereits Ende vergangenen Jahres hatten Forscherinnen und Forscher der britischen Firma DeepMind, einer Tochter der Google-Holding Alphabet, aber einen Erfolg bei einem neuartigen Ansatz vermeldet. Eine von ihnen entwickelte künstliche Intelligenz (KI) namens AlphaFold kann demnach die Strukturen von Molekülen präzise vorhersagen. Nun hat das Team um Kathryn Tunyasuvunakool, John Jumper und Demis Hassabis von DeepMind die Anwendung des Verfahrens in einem Fachartikel im Magazin »Nature«  vorgestellt. Entstanden ist eine frei zugängliche Datenbank, die viele Tausend Proteinstrukturen enthält. Diese sollen für Durchbrüche in der medizinischen Forschung genutzt werden, aber auch für die Pflanzenzucht – oder für die Entwicklung von Bakterien, die Plastik in der Umwelt zersetzen können. Abgedeckt ist dabei beinahe die komplette Menge aller 20.000 beim Menschen vorkommenden Proteine, das sogenannte Proteom, allerdings mit verschiedenen Genauigkeitsstufen. Dazu kommen Zehntausende weitere Proteine, die in anderen für die Forschung wichtigen Modellorganismen wie Mäusen, Fruchtfliegen oder Coli-Bakterien eine Rolle spielen. Die Kenntnis der Struktur ist so wichtig, weil sich auf diese Weise vorhersagen lässt, wie andere Moleküle an das Protein binden – also welche Wirkung ein bestimmter Stoff in der Praxis hat. »Wir glauben, dass es sich um das bisher vollständigste und genaueste Bild des menschlichen Proteoms handelt«, so Hassabis, der auch Chef von DeepMind ist. Seine Firma sei außerdem der Meinung, »dass diese Arbeit den bedeutendsten Beitrag darstellt, den Künstliche Intelligenz bisher zum Fortschritt des wissenschaftlichen Kenntnisstandes geleistet hat«.  »Das wird unser Verständnis darüber revolutionieren, wie Leben funktioniert«, sagt  Edith Heard vom Europäischen Laboratorium für Molekularbiologie (EMBL) in Heidelberg. »Die Anwendungsmöglichkeiten sind nur durch unsere Vorstellungskraft begrenzt.« Am EMBL wird die Datenbank der Proteinstrukturen in Zukunft betreut. Und Gira Bhabha, die sich an der New York University mit Zellbiologie beschäftigt, lobt  die Zeitersparnis für Projekte in verschiedensten Bereichen der Forschung: »Egal, ob Sie Neurowissenschaften oder Immunologie studieren – was auch immer Ihr Fachgebiet der Biologie ist – dies kann nützlich sein.« chs/jme","Facebook Bart-large",75],
["Keine einzige Zelle unseres Körpers kommt ohne sie aus: Proteine sind essenzielle Bausteine lebender Organismen. Ihr Bauplan ist in der DNA festgelegt. Zu den Proteinen gehören die Bestandteile des Immunsystems, etwa Antikörper, genauso wie Hormone, etwa Insulin, oder Enzyme, die beispielsweise im Dünndarm Milchzucker spalten und Milch verträglich machen. Wie genau ein Protein im Körper wirkt, hängt nicht nur von der Reihenfolge der Atome ab, aus denen es besteht – sondern auch von seiner Struktur: Die langen Ketten von Aminosäuren, aus denen Proteine zusammengesetzt sind, verknäulen sich zu komplexen 3D-Strukturen. Und deren Entschlüsselung gilt oft als mühsam und zeitaufwendig; dabei kommt vor allem die Methode der Röntgenkristallstrukturanalyse zum Einsatz. Bereits Ende vergangenen Jahres hatten Forscherinnen und Forscher der britischen Firma DeepMind, einer Tochter der Google-Holding Alphabet, aber einen Erfolg bei einem neuartigen Ansatz vermeldet. Eine von ihnen entwickelte künstliche Intelligenz (KI) namens AlphaFold kann demnach die Strukturen von Molekülen präzise vorhersagen. Nun hat das Team um Kathryn Tunyasuvunakool, John Jumper und Demis Hassabis von DeepMind die Anwendung des Verfahrens in einem Fachartikel im Magazin »Nature«  vorgestellt. Entstanden ist eine frei zugängliche Datenbank, die viele Tausend Proteinstrukturen enthält. Diese sollen für Durchbrüche in der medizinischen Forschung genutzt werden, aber auch für die Pflanzenzucht – oder für die Entwicklung von Bakterien, die Plastik in der Umwelt zersetzen können. Abgedeckt ist dabei beinahe die komplette Menge aller 20.000 beim Menschen vorkommenden Proteine, das sogenannte Proteom, allerdings mit verschiedenen Genauigkeitsstufen. Dazu kommen Zehntausende weitere Proteine, die in anderen für die Forschung wichtigen Modellorganismen wie Mäusen, Fruchtfliegen oder Coli-Bakterien eine Rolle spielen. Die Kenntnis der Struktur ist so wichtig, weil sich auf diese Weise vorhersagen lässt, wie andere Moleküle an das Protein binden – also welche Wirkung ein bestimmter Stoff in der Praxis hat. »Wir glauben, dass es sich um das bisher vollständigste und genaueste Bild des menschlichen Proteoms handelt«, so Hassabis, der auch Chef von DeepMind ist. Seine Firma sei außerdem der Meinung, »dass diese Arbeit den bedeutendsten Beitrag darstellt, den Künstliche Intelligenz bisher zum Fortschritt des wissenschaftlichen Kenntnisstandes geleistet hat«.  »Das wird unser Verständnis darüber revolutionieren, wie Leben funktioniert«, sagt  Edith Heard vom Europäischen Laboratorium für Molekularbiologie (EMBL) in Heidelberg. »Die Anwendungsmöglichkeiten sind nur durch unsere Vorstellungskraft begrenzt.« Am EMBL wird die Datenbank der Proteinstrukturen in Zukunft betreut. Und Gira Bhabha, die sich an der New York University mit Zellbiologie beschäftigt, lobt  die Zeitersparnis für Projekte in verschiedensten Bereichen der Forschung: »Egal, ob Sie Neurowissenschaften oder Immunologie studieren – was auch immer Ihr Fachgebiet der Biologie ist – dies kann nützlich sein.« chs/jme","Facebook DistilBART",75],
["Der Insolvenzverwalter der Drogeriemarktkette Schlecker ist mit einer Schadensersatzklage in Millionenhöhe gegen frühere Lieferanten auch in der nächsten Instanz gescheitert. Nach Angaben von Verwalter Arndt Geiwitz wies das Oberlandesgericht Frankfurt die Berufung gegen ein vorangegangenes Urteil des Landgerichts zurück. Das Gericht bestätigte dies, nannte zunächst aber keine Details zu dem Fall. Geiwitz will nun Beschwerde beim Bundesgerichtshof in Karlsruhe einlegen, weil die OLG-Richter gegen ihre Entscheidung auch keine Revision zuließen.Geiwitz verlangt von den Drogerieartikel-Herstellern rund 212 Millionen Euro Schadensersatz. Die Drogeriemarktkette soll vor ihrer Insolvenz jahrelang zu viel bezahlt haben, weil die Hersteller sich abgesprochen hatten. Bundeskartellamt und EU-Kommission hatten deshalb schon Bußgelder verhängt. Geiwitz geht nun zivilrechtlich gegen die Kartelle vor.Geiwitz teilte mit, dass er von Anfang an auf langwierige und komplexe Prozesse durch die Instanzen eingestellt gewesen sei. Überraschend sei die Entscheidung aber, weil das Gericht noch vor wenigen Wochen in einem vergleichbaren Verfahren einer anderen Drogeriemarktkette zugunsten des Klägers einen Beweisbeschluss erlassen habe. \"Wir kämpfen mit den Kartellklagen primär für die Masse-Gläubiger und damit allen voran auch für die Schlecker-Mitarbeiterinnen und -Mitarbeiter wie auch für jeden Steuerzahler, da die Bundesagentur für Arbeit hohe Ansprüche hat\", sagte Geiwitz. Aktenzeichen: 11 U 98/18","Google T5-base",75],
["Der Insolvenzverwalter der Drogeriemarktkette Schlecker ist mit einer Schadensersatzklage in Millionenhöhe gegen frühere Lieferanten auch in der nächsten Instanz gescheitert. Nach Angaben von Verwalter Arndt Geiwitz wies das Oberlandesgericht Frankfurt die Berufung gegen ein vorangegangenes Urteil des Landgerichts zurück. Das Gericht bestätigte dies, nannte zunächst aber keine Details zu dem Fall. Geiwitz will nun Beschwerde beim Bundesgerichtshof in Karlsruhe einlegen, weil die OLG-Richter gegen ihre Entscheidung auch keine Revision zuließen.Geiwitz verlangt von den Drogerieartikel-Herstellern rund 212 Millionen Euro Schadensersatz. Die Drogeriemarktkette soll vor ihrer Insolvenz jahrelang zu viel bezahlt haben, weil die Hersteller sich abgesprochen hatten. Bundeskartellamt und EU-Kommission hatten deshalb schon Bußgelder verhängt. Geiwitz geht nun zivilrechtlich gegen die Kartelle vor.Geiwitz teilte mit, dass er von Anfang an auf langwierige und komplexe Prozesse durch die Instanzen eingestellt gewesen sei. Überraschend sei die Entscheidung aber, weil das Gericht noch vor wenigen Wochen in einem vergleichbaren Verfahren einer anderen Drogeriemarktkette zugunsten des Klägers einen Beweisbeschluss erlassen habe. \"Wir kämpfen mit den Kartellklagen primär für die Masse-Gläubiger und damit allen voran auch für die Schlecker-Mitarbeiterinnen und -Mitarbeiter wie auch für jeden Steuerzahler, da die Bundesagentur für Arbeit hohe Ansprüche hat\", sagte Geiwitz. Aktenzeichen: 11 U 98/18","Facebook Bart-large",75],
["Der Insolvenzverwalter der Drogeriemarktkette Schlecker ist mit einer Schadensersatzklage in Millionenhöhe gegen frühere Lieferanten auch in der nächsten Instanz gescheitert. Nach Angaben von Verwalter Arndt Geiwitz wies das Oberlandesgericht Frankfurt die Berufung gegen ein vorangegangenes Urteil des Landgerichts zurück. Das Gericht bestätigte dies, nannte zunächst aber keine Details zu dem Fall. Geiwitz will nun Beschwerde beim Bundesgerichtshof in Karlsruhe einlegen, weil die OLG-Richter gegen ihre Entscheidung auch keine Revision zuließen.Geiwitz verlangt von den Drogerieartikel-Herstellern rund 212 Millionen Euro Schadensersatz. Die Drogeriemarktkette soll vor ihrer Insolvenz jahrelang zu viel bezahlt haben, weil die Hersteller sich abgesprochen hatten. Bundeskartellamt und EU-Kommission hatten deshalb schon Bußgelder verhängt. Geiwitz geht nun zivilrechtlich gegen die Kartelle vor.Geiwitz teilte mit, dass er von Anfang an auf langwierige und komplexe Prozesse durch die Instanzen eingestellt gewesen sei. Überraschend sei die Entscheidung aber, weil das Gericht noch vor wenigen Wochen in einem vergleichbaren Verfahren einer anderen Drogeriemarktkette zugunsten des Klägers einen Beweisbeschluss erlassen habe. \"Wir kämpfen mit den Kartellklagen primär für die Masse-Gläubiger und damit allen voran auch für die Schlecker-Mitarbeiterinnen und -Mitarbeiter wie auch für jeden Steuerzahler, da die Bundesagentur für Arbeit hohe Ansprüche hat\", sagte Geiwitz. Aktenzeichen: 11 U 98/18","Google Pegasus",75],
["Der Insolvenzverwalter der Drogeriemarktkette Schlecker ist mit einer Schadensersatzklage in Millionenhöhe gegen frühere Lieferanten auch in der nächsten Instanz gescheitert. Nach Angaben von Verwalter Arndt Geiwitz wies das Oberlandesgericht Frankfurt die Berufung gegen ein vorangegangenes Urteil des Landgerichts zurück. Das Gericht bestätigte dies, nannte zunächst aber keine Details zu dem Fall. Geiwitz will nun Beschwerde beim Bundesgerichtshof in Karlsruhe einlegen, weil die OLG-Richter gegen ihre Entscheidung auch keine Revision zuließen.Geiwitz verlangt von den Drogerieartikel-Herstellern rund 212 Millionen Euro Schadensersatz. Die Drogeriemarktkette soll vor ihrer Insolvenz jahrelang zu viel bezahlt haben, weil die Hersteller sich abgesprochen hatten. Bundeskartellamt und EU-Kommission hatten deshalb schon Bußgelder verhängt. Geiwitz geht nun zivilrechtlich gegen die Kartelle vor.Geiwitz teilte mit, dass er von Anfang an auf langwierige und komplexe Prozesse durch die Instanzen eingestellt gewesen sei. Überraschend sei die Entscheidung aber, weil das Gericht noch vor wenigen Wochen in einem vergleichbaren Verfahren einer anderen Drogeriemarktkette zugunsten des Klägers einen Beweisbeschluss erlassen habe. \"Wir kämpfen mit den Kartellklagen primär für die Masse-Gläubiger und damit allen voran auch für die Schlecker-Mitarbeiterinnen und -Mitarbeiter wie auch für jeden Steuerzahler, da die Bundesagentur für Arbeit hohe Ansprüche hat\", sagte Geiwitz. Aktenzeichen: 11 U 98/18","Facebook DistilBART",75],
["Der Insolvenzverwalter der Drogeriemarktkette Schlecker ist mit einer Schadensersatzklage in Millionenhöhe gegen frühere Lieferanten auch in der nächsten Instanz gescheitert. Nach Angaben von Verwalter Arndt Geiwitz wies das Oberlandesgericht Frankfurt die Berufung gegen ein vorangegangenes Urteil des Landgerichts zurück. Das Gericht bestätigte dies, nannte zunächst aber keine Details zu dem Fall. Geiwitz will nun Beschwerde beim Bundesgerichtshof in Karlsruhe einlegen, weil die OLG-Richter gegen ihre Entscheidung auch keine Revision zuließen.Geiwitz verlangt von den Drogerieartikel-Herstellern rund 212 Millionen Euro Schadensersatz. Die Drogeriemarktkette soll vor ihrer Insolvenz jahrelang zu viel bezahlt haben, weil die Hersteller sich abgesprochen hatten. Bundeskartellamt und EU-Kommission hatten deshalb schon Bußgelder verhängt. Geiwitz geht nun zivilrechtlich gegen die Kartelle vor.Geiwitz teilte mit, dass er von Anfang an auf langwierige und komplexe Prozesse durch die Instanzen eingestellt gewesen sei. Überraschend sei die Entscheidung aber, weil das Gericht noch vor wenigen Wochen in einem vergleichbaren Verfahren einer anderen Drogeriemarktkette zugunsten des Klägers einen Beweisbeschluss erlassen habe. \"Wir kämpfen mit den Kartellklagen primär für die Masse-Gläubiger und damit allen voran auch für die Schlecker-Mitarbeiterinnen und -Mitarbeiter wie auch für jeden Steuerzahler, da die Bundesagentur für Arbeit hohe Ansprüche hat\", sagte Geiwitz. Aktenzeichen: 11 U 98/18","Google MT5-small",75],
["Der Schweizer Carlo Janka hat im südkoreanischen Jeongseon den Super-G gewonnen. Es war der erste Schweizer Sieg im alpinen Weltcup der Männer seit über einem Jahr und Jankas erster Super-G-Erfolg überhaupt. Während Andreas Sander auf den zehnten Rang fuhr, siegte der Riesenslalom-Olympiasieger von 2010 mit einer Zeit von 1:26,16 klar vor dem Italiener Christof Innerhofer (+0,82 Sekunden) und dem Österreicher Vincent Kriechmayr (+1,06). Janka hatte zuletzt im Januar 2015 die Kombination in Wengen gewonnen, davor aber vier Jahre lang gar nicht. Der 30-Jährige kämpft seit Jahren mit Rückenproblemen. Bei der Weltcup-Abfahrt zwei Wochen zuvor auf der Streif in Kitzbühel hatte er als Dritter überrascht. Der Super-G-Kurs auf der eigens für Olympia gebauten Strecke in Jeongseon erwies sich vor allem wegen der Sprünge als sehr tückisch. Zahlreiche Fahrer schieden aus, darunter auch Kjetil Jansrud aus Norwegen, der am Vortag die Abfahrt gewonnen hatte.Bei minus zwölf Grad und strahlendem Sonnenschein zog der deutsche Alpinchef Wolfgang Maier ein positives Fazit nach dem ersten Testlauf für die Winterspiele in zwei Jahren. \"Bis Olympia wird noch viel verändert, und wir müssen auch noch viel arbeiten, um beim Material mit diesen kalten Bedingungen zurecht zu kommen\", sagte Maier. \"Aber wir haben gesehen, dass wir uns im Spitzenbereich bewegen können.\"Ein Sonderlob gab es für die Veranstalter. \"Das war eine außergewöhnlich gute Piste\", betonte Maier. \"Dafür, dass es ein komplett neu aus dem Boden gestampftes Skigebiet ist, haben sie das wirklich gut gemacht. Im November stand hier nicht mal ein Lift.\" rae/dpa/sid","Google T5-base",75],
["Der Schweizer Carlo Janka hat im südkoreanischen Jeongseon den Super-G gewonnen. Es war der erste Schweizer Sieg im alpinen Weltcup der Männer seit über einem Jahr und Jankas erster Super-G-Erfolg überhaupt. Während Andreas Sander auf den zehnten Rang fuhr, siegte der Riesenslalom-Olympiasieger von 2010 mit einer Zeit von 1:26,16 klar vor dem Italiener Christof Innerhofer (+0,82 Sekunden) und dem Österreicher Vincent Kriechmayr (+1,06). Janka hatte zuletzt im Januar 2015 die Kombination in Wengen gewonnen, davor aber vier Jahre lang gar nicht. Der 30-Jährige kämpft seit Jahren mit Rückenproblemen. Bei der Weltcup-Abfahrt zwei Wochen zuvor auf der Streif in Kitzbühel hatte er als Dritter überrascht. Der Super-G-Kurs auf der eigens für Olympia gebauten Strecke in Jeongseon erwies sich vor allem wegen der Sprünge als sehr tückisch. Zahlreiche Fahrer schieden aus, darunter auch Kjetil Jansrud aus Norwegen, der am Vortag die Abfahrt gewonnen hatte.Bei minus zwölf Grad und strahlendem Sonnenschein zog der deutsche Alpinchef Wolfgang Maier ein positives Fazit nach dem ersten Testlauf für die Winterspiele in zwei Jahren. \"Bis Olympia wird noch viel verändert, und wir müssen auch noch viel arbeiten, um beim Material mit diesen kalten Bedingungen zurecht zu kommen\", sagte Maier. \"Aber wir haben gesehen, dass wir uns im Spitzenbereich bewegen können.\"Ein Sonderlob gab es für die Veranstalter. \"Das war eine außergewöhnlich gute Piste\", betonte Maier. \"Dafür, dass es ein komplett neu aus dem Boden gestampftes Skigebiet ist, haben sie das wirklich gut gemacht. Im November stand hier nicht mal ein Lift.\" rae/dpa/sid","Google Pegasus",75],
["Der Schweizer Carlo Janka hat im südkoreanischen Jeongseon den Super-G gewonnen. Es war der erste Schweizer Sieg im alpinen Weltcup der Männer seit über einem Jahr und Jankas erster Super-G-Erfolg überhaupt. Während Andreas Sander auf den zehnten Rang fuhr, siegte der Riesenslalom-Olympiasieger von 2010 mit einer Zeit von 1:26,16 klar vor dem Italiener Christof Innerhofer (+0,82 Sekunden) und dem Österreicher Vincent Kriechmayr (+1,06). Janka hatte zuletzt im Januar 2015 die Kombination in Wengen gewonnen, davor aber vier Jahre lang gar nicht. Der 30-Jährige kämpft seit Jahren mit Rückenproblemen. Bei der Weltcup-Abfahrt zwei Wochen zuvor auf der Streif in Kitzbühel hatte er als Dritter überrascht. Der Super-G-Kurs auf der eigens für Olympia gebauten Strecke in Jeongseon erwies sich vor allem wegen der Sprünge als sehr tückisch. Zahlreiche Fahrer schieden aus, darunter auch Kjetil Jansrud aus Norwegen, der am Vortag die Abfahrt gewonnen hatte.Bei minus zwölf Grad und strahlendem Sonnenschein zog der deutsche Alpinchef Wolfgang Maier ein positives Fazit nach dem ersten Testlauf für die Winterspiele in zwei Jahren. \"Bis Olympia wird noch viel verändert, und wir müssen auch noch viel arbeiten, um beim Material mit diesen kalten Bedingungen zurecht zu kommen\", sagte Maier. \"Aber wir haben gesehen, dass wir uns im Spitzenbereich bewegen können.\"Ein Sonderlob gab es für die Veranstalter. \"Das war eine außergewöhnlich gute Piste\", betonte Maier. \"Dafür, dass es ein komplett neu aus dem Boden gestampftes Skigebiet ist, haben sie das wirklich gut gemacht. Im November stand hier nicht mal ein Lift.\" rae/dpa/sid","Google MT5-small",75],
["Der Schweizer Carlo Janka hat im südkoreanischen Jeongseon den Super-G gewonnen. Es war der erste Schweizer Sieg im alpinen Weltcup der Männer seit über einem Jahr und Jankas erster Super-G-Erfolg überhaupt. Während Andreas Sander auf den zehnten Rang fuhr, siegte der Riesenslalom-Olympiasieger von 2010 mit einer Zeit von 1:26,16 klar vor dem Italiener Christof Innerhofer (+0,82 Sekunden) und dem Österreicher Vincent Kriechmayr (+1,06). Janka hatte zuletzt im Januar 2015 die Kombination in Wengen gewonnen, davor aber vier Jahre lang gar nicht. Der 30-Jährige kämpft seit Jahren mit Rückenproblemen. Bei der Weltcup-Abfahrt zwei Wochen zuvor auf der Streif in Kitzbühel hatte er als Dritter überrascht. Der Super-G-Kurs auf der eigens für Olympia gebauten Strecke in Jeongseon erwies sich vor allem wegen der Sprünge als sehr tückisch. Zahlreiche Fahrer schieden aus, darunter auch Kjetil Jansrud aus Norwegen, der am Vortag die Abfahrt gewonnen hatte.Bei minus zwölf Grad und strahlendem Sonnenschein zog der deutsche Alpinchef Wolfgang Maier ein positives Fazit nach dem ersten Testlauf für die Winterspiele in zwei Jahren. \"Bis Olympia wird noch viel verändert, und wir müssen auch noch viel arbeiten, um beim Material mit diesen kalten Bedingungen zurecht zu kommen\", sagte Maier. \"Aber wir haben gesehen, dass wir uns im Spitzenbereich bewegen können.\"Ein Sonderlob gab es für die Veranstalter. \"Das war eine außergewöhnlich gute Piste\", betonte Maier. \"Dafür, dass es ein komplett neu aus dem Boden gestampftes Skigebiet ist, haben sie das wirklich gut gemacht. Im November stand hier nicht mal ein Lift.\" rae/dpa/sid","Facebook DistilBART",75],
["Der Schweizer Carlo Janka hat im südkoreanischen Jeongseon den Super-G gewonnen. Es war der erste Schweizer Sieg im alpinen Weltcup der Männer seit über einem Jahr und Jankas erster Super-G-Erfolg überhaupt. Während Andreas Sander auf den zehnten Rang fuhr, siegte der Riesenslalom-Olympiasieger von 2010 mit einer Zeit von 1:26,16 klar vor dem Italiener Christof Innerhofer (+0,82 Sekunden) und dem Österreicher Vincent Kriechmayr (+1,06). Janka hatte zuletzt im Januar 2015 die Kombination in Wengen gewonnen, davor aber vier Jahre lang gar nicht. Der 30-Jährige kämpft seit Jahren mit Rückenproblemen. Bei der Weltcup-Abfahrt zwei Wochen zuvor auf der Streif in Kitzbühel hatte er als Dritter überrascht. Der Super-G-Kurs auf der eigens für Olympia gebauten Strecke in Jeongseon erwies sich vor allem wegen der Sprünge als sehr tückisch. Zahlreiche Fahrer schieden aus, darunter auch Kjetil Jansrud aus Norwegen, der am Vortag die Abfahrt gewonnen hatte.Bei minus zwölf Grad und strahlendem Sonnenschein zog der deutsche Alpinchef Wolfgang Maier ein positives Fazit nach dem ersten Testlauf für die Winterspiele in zwei Jahren. \"Bis Olympia wird noch viel verändert, und wir müssen auch noch viel arbeiten, um beim Material mit diesen kalten Bedingungen zurecht zu kommen\", sagte Maier. \"Aber wir haben gesehen, dass wir uns im Spitzenbereich bewegen können.\"Ein Sonderlob gab es für die Veranstalter. \"Das war eine außergewöhnlich gute Piste\", betonte Maier. \"Dafür, dass es ein komplett neu aus dem Boden gestampftes Skigebiet ist, haben sie das wirklich gut gemacht. Im November stand hier nicht mal ein Lift.\" rae/dpa/sid","Facebook Bart-large",75]]

#interface = gr.Interface.load("models/Einmalumdiewelt/T5-Base_GNAD",
#            title=title,
#            description=description,
#            examples=examples)

# text input box
txt=gr.Textbox(lines=15, label="Here's your German text:", placeholder="Paste your German text in here.")
# dropdown model selection
drop=gr.Dropdown(["Google T5-base","Google MT5-small","Google Pegasus","Facebook Bart-large","Facebook DistilBART"],label="Choose a fine-tuned architecture.")
# slider summary length selection
slide=gr.Slider(25, 150, step=25, label="Select a preferred summary length (+/- 25 tokens).", value=75)
# text output box
out=gr.Textbox(lines=5, label="Here's your summary:")
            
interface = gr.Interface(summarize,
            inputs=[
            txt,
            # Selection of models for inference
            drop,
            # Length of summaries
            slide],
            # ouptut
            outputs=out,
            title=title,
            description=description,
            examples=examples)
            
# launch interface                    
if __name__ == "__main__":
    interface.launch(share=True)            