'''
Author: Egrt
Date: 2022-01-13 13:34:10
LastEditors: [egrt]
LastEditTime: 2022-05-04 12:59:41
FilePath: \MaskGAN\app.py
'''
import os
os.system('pip install requirements.txt')
from PIL import Image
from maskgan import MASKGAN
import gradio as gr
import os
maskgan = MASKGAN()

# --------模型推理---------- #
def inference(img):
    lr_shape = [112, 112]
    img = img.resize(tuple(lr_shape), Image.BICUBIC)
    r_image = maskgan.generate_1x1_image(img)
    return r_image

# --------网页信息---------- #  
title = "MaskGAN:融合无监督的口罩遮挡人脸修复"
description = "使用生成对抗网络对口罩遮挡人脸进行修复,能够有效的恢复被遮挡区域人脸。  @西南科技大学智能控制与图像处理研究室"
article = "<p style='text-align: center'><a href='https://arxiv.org/abs/2108.10257' target='_blank'>MaskGAN: Face Restoration Using Swin Transformer</a> | <a href='https://github.com/JingyunLiang/SwinIR' target='_blank'>Github Repo</a></p>"
example_img_dir  = 'img'
example_img_name = os.listdir(example_img_dir)
examples=[[os.path.join(example_img_dir, image_path)] for image_path in example_img_name if image_path.endswith('.jpg')]
gr.Interface(
    inference, 
    [gr.inputs.Image(type="pil", label="Input")], 
    gr.outputs.Image(type="pil", label="Output"),
    title=title,
    description=description,
    article=article,
    enable_queue=True,
    examples=examples
    ).launch(debug=True)
