'''
Author: Egrt
Date: 2022-01-13 13:34:10
LastEditors: Egrt
LastEditTime: 2022-10-31 17:08:34
FilePath: \MaskGAN\app.py
'''
from cyclegan import CYCLEGAN
import gradio as gr
import os

cyclegan = CYCLEGAN()

# --------模型推理---------- #
'''
description: 
param {*} img 戴眼镜的人脸图片 Image
return {*} r_image 去遮挡的人脸图片 Image
'''
def inference(img):
    r_image = cyclegan.detect_image(img)
    return r_image
    
# --------网页信息---------- #  
title = "融合无监督的戴眼镜遮挡人脸重建"
description = "使用生成对抗网络对戴眼镜遮挡人脸重建,能够有效地去除眼镜遮挡。  @西南科技大学智能控制与图像处理研究室"
article = "<p style='text-align: center'>DeMaskGAN: Face Restoration Using Swin Transformer </p>"
example_img_dir  = 'img'
example_img_name = os.listdir(example_img_dir)
examples=[os.path.join(example_img_dir, image_path) for image_path in example_img_name if image_path.endswith(('.jpg','.jpeg'))]
gr.Interface(
    inference, 
    gr.inputs.Image(type="pil", label="Input", tool="editor"),
    gr.outputs.Image(type="pil", label="Output").style(height=242),
    title=title,
    description=description,
    article=article,
    examples=examples
    ).launch()
