from fastai.vision.all import *
import gradio as gr

# Return a prediction
def get_prediction( image ):
    categories = ("Guinea pig", "Potatoe")
    category, category_idx, probabilities = learn.predict(image)
    return dict(zip(categories, map(float, probabilities)))

# Load model
learn = load_learner('piggie_or_potatoe.pkl')

# Create Gradio interface
title = "Piggie-or-potatoe classifier"
description = "One of them you want to hug, and the other one you want to eat. Now you need never again mix up your guinea pigs with your potatoes! Take picture of what you are about to eat or hug and stop everyday tragedy. Built using Fastai and HuggingFace Gradio on HuggingFace Spaces."
image = gr.inputs.Image(shape=(192, 192))
label = gr.outputs.Label()
examples = ['guinea_pig.jpeg', 'potatoe.jpeg', 'guinea_pig_potatoe.jpeg']

grinference = gr.Interface(fn=get_prediction, inputs=image, outputs=label, examples=examples)
grinference.launch(inline=False)
