import streamlit as st


def sticky_bottom_bar(text):
    # Style the sticky bottom bar
    st.markdown(
        f"""
        <style>
        .sticky-bottom-bar {{
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: #3085C3;
            text-align: center;
            padding: 10px 0;
            z-index: 999; /* Bring it to the top layer */
        }}
        .sticky-bottom-bar-text {{
            color: white;
            font-size: 24px;
        }}
        </style>
        """,
        unsafe_allow_html=True,
    )

    # Create the sticky bottom bar
    st.markdown(
        f"""
        <div class="sticky-bottom-bar">
            <p class="sticky-bottom-bar-text">{text}</p>
        </div>
        """,
        unsafe_allow_html=True,
    )
