import pandas as pd
import numpy as np
import seaborn as sns
import pandas as pddef
import matplotlib.pyplot as plt
import streamlit as st
from scipy.stats import gaussian_kde

plt.rcParams.update(
    {
        "figure.facecolor": (1.0, 0.0, 0.0, 0.0),  # red   with alpha = 30%
        "axes.facecolor": (0.0, 1.0, 0.0, 0.0),  # green with alpha = 50%
        "savefig.facecolor": (0.0, 0.0, 1.0, 0.0),  # blue  with alpha = 20%
        "legend.facecolor": (1.0, 1.0, 1.0, 0.0),
    }
)

mean = 0
sd=1

x = np.linspace(mean - 3 * sd, mean + 3 * sd, 50)
y = (1 / (sd * np.sqrt(2 * np.pi))) * np.exp(-(x - mean) ** 2 / (2 * sd ** 2))

# Shade the 68% confidence interval
x_interval_68 = np.linspace(mean - sd, mean + sd, 50)
x_interval_95 = np.linspace(mean - 2*sd, mean + 2*sd, 50)
y_interval_68 = (1 / (sd * np.sqrt(2 * np.pi))) * np.exp(-(x_interval_68 - mean) ** 2 / (2 * sd ** 2))
y_interval_95 = (1 / (sd * np.sqrt(2 * np.pi))) * np.exp(-(x_interval_95 - mean) ** 2 / (2 * sd ** 2))

x_ticks_ = [mean - 2 * sd, mean - sd, mean, mean + sd, mean + 2 * sd]

def calculate_percentiles(arr, capital_invested):
    """
    Calculate the 10th, 25th, 50th (median), 75th, 90th, and the percentile of the value closest to 0 in an array.
    Also, add a column that represents the values as a percentage of capital invested.

    Args:
    arr (list or numpy.ndarray): Input array.
    capital_invested (float): The amount of capital invested.

    Returns:
    pandas.DataFrame: A DataFrame with percentiles and value as a percentage of capital invested.
    """
    if not isinstance(arr, (list, np.ndarray)):
        raise ValueError("Input must be a list or numpy.ndarray")

    percentiles = [10, 25, 50, 75, 90]
    percentile_values = np.percentile(arr, percentiles)

    # Find the value closest to 0
    closest_value = min(arr, key=lambda x: abs(x - 0))

    # Calculate the percentile of the closest value
    sorted_arr = np.sort(arr)
    index_of_closest = np.where(sorted_arr == closest_value)[0][0]
    closest_percentile = (index_of_closest / (len(sorted_arr) - 1)) * 100

    # Create the DataFrame with the "Value as % of Capital" column
    data = {
        "Percentile": percentiles + [closest_percentile],
        "NPV": np.append(percentile_values, closest_value),
    }

    df = pd.DataFrame(data)
    df["% return"] = (df["NPV"] / capital_invested) * 100

    return df


def bin_continuous_features(df, bin_config):
    """
    Encode continuous features into bins and add them as new columns to the DataFrame.

    Parameters:
    - df: pandas DataFrame
        The DataFrame containing the continuous features.
    - bin_config: dict
        A dictionary specifying the binning configuration for each feature.
        Example: {'feature1': [0, 10, 20, 30], 'feature2': [0, 5, 10]}

    Returns:
    - df: pandas DataFrame
        The DataFrame with binned features added as new columns.
    """

    for feature, bins in bin_config.items():
        # Create a new column with the binned values
        df[f"{feature}_bin"] = pd.cut(df[feature], bins=bins, labels=False)

    return df


def get_param_distribution(
    mean, std, samples, plot=True, as_int=False, xlabel="", sidebar=False
):
    if std <= 0:
        return np.array([mean])

    s = np.random.normal(mean, std, samples)

    if plot:
        plot_normal_distribution(mean, std, xlabel=xlabel, sidebar = sidebar)
    if as_int:
        s = s.astype(int)

    return s


def plot_normal_distribution(mean, sd, xlabel="", sidebar=False):
    # Create a figure and axis
    fig, ax = plt.subplots(figsize=(6, 1.5))

    # Plot the normal distribution curve
    ax.plot(x, y)

    ax.fill_between(x_interval_68, y_interval_68, color = '#b8d7ed', alpha=1, label='68% CI')
    ax.fill_between(x_interval_95, y_interval_95, color = '#b8d7ed', alpha=0.5, label='95% CI')
    
    ax.set_xticks(x_ticks_)
    # Set y-axis lower limit to 0
    ax.set_ylim(0)
    # fig.set_size_inches(6, 1.5)
    # Set x-axis ticks to mean, mean ± 1 SD, and mean ± 2 SD
    x_ticks = ['{:.1f}'.format(mean - 2 * sd), '{:.1f}'.format(mean - sd), '{:.1f}'.format(mean),
           '{:.1f}'.format(mean + sd), '{:.1f}'.format(mean + 2 * sd)]
    ax.set_xticklabels([float(tick) for tick in x_ticks])
    # Set axis labels and a title
    ax.set_xlabel(xlabel)
    # ax.set_ylabel('Probability Density')
    ax.set_title('Assumed Distribution')

    # Create a legend
    # ax.legend(loc='upper right')
    ax.legend(shadow=True)
    ax.get_yaxis().set_visible(False)
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.spines["left"].set_visible(False)
    # Show the plot
    if sidebar:
        st.sidebar.pyplot(fig)
    else:
        st.pyplot(fig)