import streamlit as st
import numpy as np
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.ticker as mticker
import seaborn as sns
matplotlib.rcParams["axes.formatter.limits"] = (-99, 99)


def plot_hist_from_list(arrays, st, figsize=(7, 2), main_colors = ['green'], secondary_color = 'red', legends = None, title = 'Net Present Value Probability Distribution', xlabel = 'Net Present Value For Property Purchase', plot_below_zero = False, clip = None):
    fig, ax = plt.subplots(figsize=figsize)
    x_lower = []
    x_higher = []
    for num, array in enumerate(arrays):
        # Plot the entire KDE plot in one color
        sns.histplot(data=array, ax=ax, color=main_colors[num-1],alpha=0.3,linewidth=0.2)
        # Plot the shaded area to the left of 0 in a different color
        x_mean = np.mean(array)
        x_std = np.std(array)
        x_lower.append(x_mean-3*x_std)
        x_higher.append(x_mean+3*x_std)
    
    # Set the axis limits based on the 95th percentile
    ax.xaxis.set_major_formatter(mticker.FuncFormatter(format_with_commas))
    ax.set_xlim(np.min(x_lower), np.max(x_higher))
    ax.set_xlabel(xlabel)
    ax.set_ylabel("Frequency")
    ax.set_xticklabels(ax.get_xticklabels(), rotation=45)
    ax.set_title(title)
    if legends:
        plt.legend(labels=legends)
    st.pyplot(fig)

### UNUSED ###
def format_with_commas(x, pos):
    return '{:,.0f}'.format(x)


def graph_kde_plots(results_df, FEATURES, num_cols = 2):
    
    # Calculate the number of rows and columns needed for subplots
    num_features = len(FEATURES)
    num_rows = (num_features + num_cols - 1) // num_cols
    # Create a figure and axis for subplots
    fig, axes = plt.subplots(num_rows, num_cols, figsize=(15, 5 * num_rows))

    # Flatten the axes if necessary (in case there's only one row)
    if num_rows == 1:
        axes = axes.reshape(1, -1)
    # Loop through each feature and plot it
    for i, feature in enumerate(FEATURES):
        row = i // num_cols
        col = i % num_cols
        ax = axes[row, col]
        
        sns.kdeplot(data=results_df, x=feature, y="buying_npv", bw_adjust = 1.5, ax=ax, fill=True)
        ax.set_title(f"{feature} vs. buying_npv")
        ax.set_ylabel("buying_npv")
        ax.set_xlabel(feature)
         # Calculate the 95th percentile for x and y axes
        x_low_percentile = np.percentile(results_df[feature], 0.1)
        y_low_percentile = np.percentile(results_df['buying_npv'], 0.1)
        x_high_percentile = np.percentile(results_df[feature], 99.9)
        y_high_percentile = np.percentile(results_df['buying_npv'], 99.9)
        
        # Set the axis limits based on the 95th percentile
        ax.set_xlim(x_low_percentile, x_high_percentile)
        ax.set_ylim(y_low_percentile, y_high_percentile)
        ax.yaxis.set_major_formatter(mticker.FuncFormatter(format_with_commas))
    
        # ax.set_xticklabels(ax.get_xticklabels(), rotation=45)  # Adjust the rotation angle as needed
        
    # Remove any empty subplots
    for i in range(len(FEATURES), num_rows * num_cols):
        fig.delaxes(axes.flatten()[i])

    # Adjust spacing between subplots
    plt.tight_layout()

    # Show the plots
    plt.show()
    st.pyplot(fig)