import gradio as gr
import transformers
from transformers import pipeline

summarizer = pipeline("summarization")

def summarize(text):
  return summarizer(text, max_length=200, min_length=30)[0]['summary_text']
  
gr.Interface(fn=summarize, inputs=gr.inputs.Textbox(lines=7, placeholder="Enter text here"), outputs="text").launch()