import os
import gradio as gr

title = "Have Fun With ChubbyBot"
description = """
<p>
<center>
The bot is trained on blended_skill_talk dataset using facebook/blenderbot-400M-distill.
<img src="https://huggingface.co/spaces/EXFINITE/BlenderBot-UI/resolve/main/img/cover.png" alt="rick" width="250"/>
</center>
</p>
"""
article = "<p style='text-align: center'><a href='https://arxiv.org/abs/1907.06616' target='_blank'>Recipes for building an open-domain chatbot</a></p><p style='text-align: center'><a href='https://parl.ai/projects/recipes/' target='_blank'>Original PARLAI Code</a></p></center></p>"

import torch
from transformers import AutoTokenizer, AutoModelForSeq2SeqLM, BlenderbotForConditionalGeneration, BlenderbotForCausalLM, BlenderbotTokenizer

tokenizer = BlenderbotTokenizer.from_pretrained("facebook/blenderbot-400M-distill")
model = BlenderbotForConditionalGeneration.from_pretrained("facebook/blenderbot-400M-distill",add_cross_attention=False)

def predict(input, history=[]):
    # tokenize the new input sentence
    new_user_input_ids = tokenizer.encode(input + tokenizer.eos_token, return_tensors='pt')

    # append the new user input tokens to the chat history
    bot_input_ids = torch.cat([torch.LongTensor(history), new_user_input_ids], dim=-1)

    # generate a response 
    history = model.generate(bot_input_ids, max_length=1000, pad_token_id=tokenizer.eos_token_id).tolist()

    # convert the tokens to text, and then split the responses into the right format
    response = tokenizer.decode(history[0]).replace("<s>","").split("</s>")
    response = [(response[i], response[i+1]) for i in range(0, len(response), 2)]  # convert to tuples of list
    return response, history

gr.Interface(
		fn = predict, 
		inputs = ["textbox","state"], 
		outputs = ["chatbot","state"],
		theme ="seafoam",
		title = title, 
		description = description, 
		article = article 
		).launch(enable_queue=True)
