---
title: Deepest
colorFrom: red
colorTo: purple
sdk: gradio
sdk_version: "3.9"
python_version: "3.10"
app_file: app.py
pinned: false
model: St0nedB/deepest-public
---

# Demo of `deepest` parameter estimator
This repository is a demo of the `deepest` parameter estimator introduced in [arxiv](https://arxiv.org/abs/2211.04846).

## Usage
Start by installing the requirements from the `requirements.txt`.
```bash
python -m pip install -r requirements.txt
```

The repository uses `secrets` to avoid leaking non-public information (i.e. the code, the trained model, git urls and access tokens) which can occur when users clone the repository.
If you are in possesion of those secrets, set them as the following environement variables in your shell:
```bash
export MODEL_TOKEN=<Access Token for the Huggingface Model Git>
export GIT_TOKEN=<Access Token for the `deepest` repository>
export GIT_URL=<Url of the `deepest` repository>
export GIT_COMMIT=<The commit shasum for the `deepest` version>
```

Then run the `app.py` via
```bash
python app.py
```

## Paper
You can find the current version of the paper on [arxiv](https://arxiv.org/abs/2211.04846).