#!/usr/bin/env python

from __future__ import annotations

import gradio as gr

from paper_list import PaperList

DESCRIPTION = '# ECCV 2022 Papers'
NOTES = '''
- [ECCV 2022](https://eccv2022.ecva.net/)
- [List of accepted papers](https://docs.google.com/spreadsheets/d/1PvvnVAuG9TDov1rBQcLhH5noIM4INTfLhKwrk6ESDFU/edit?usp=sharing)
'''
FOOTER = '<img id="visitor-badge" alt="visitor badge" src="https://visitor-badge.glitch.me/badge?page_id=hysts.eccv2022_papers" />'


def main():
    paper_list = PaperList()

    with gr.Blocks(css='style.css') as demo:
        gr.Markdown(DESCRIPTION)

        search_box = gr.Textbox(
            label='Search Title',
            placeholder=
            'You can search for titles with regular expressions. e.g. (?<!sur)face',
            max_lines=1)
        case_sensitive = gr.Checkbox(label='Case Sensitive')
        filter_names = gr.CheckboxGroup(choices=[
            'arXiv',
            'GitHub',
            'HF Space',
            'HF Model',
            'HF Dataset',
        ],
                                        label='Filter')
        session_names = [
            'Oral',
            'Poster',
        ]
        paper_sessions = gr.CheckboxGroup(choices=session_names,
                                          value=session_names,
                                          label='Session')
        search_button = gr.Button('Search')

        number_of_papers = gr.Textbox(label='Number of Papers Found')
        table = gr.HTML(show_label=False)

        gr.Markdown(NOTES)
        gr.Markdown(FOOTER)

        demo.load(fn=paper_list.render,
                  inputs=[
                      search_box,
                      case_sensitive,
                      filter_names,
                      paper_sessions,
                  ],
                  outputs=[
                      number_of_papers,
                      table,
                  ])
        search_box.submit(fn=paper_list.render,
                          inputs=[
                              search_box,
                              case_sensitive,
                              filter_names,
                              paper_sessions,
                          ],
                          outputs=[
                              number_of_papers,
                              table,
                          ])

        search_button.click(fn=paper_list.render,
                            inputs=[
                                search_box,
                                case_sensitive,
                                filter_names,
                                paper_sessions,
                            ],
                            outputs=[
                                number_of_papers,
                                table,
                            ])

    demo.launch(enable_queue=True, share=False)


if __name__ == '__main__':
    main()
