import streamlit as st
import os
import io
import IPython.display
from PIL import Image
import base64 
from transformers import pipeline

# Load the image captioning model
get_completion = pipeline("image-to-text", model="Salesforce/blip-image-captioning-base")

def image_to_base64_str(pil_image):
    byte_arr = io.BytesIO()
    pil_image.save(byte_arr, format='PNG')
    byte_arr = byte_arr.getvalue()
    return str(base64.b64encode(byte_arr).decode('utf-8'))

# Streamlit app
st.title("Image Captioning demo for Vision Mate bot")

# Upload image
image = st.file_uploader("Upload an image", type=["jpg", "jpeg", "png"])

if image:
    # Display the uploaded image with a smaller width
    st.image(image, caption="Uploaded Image", width=400)  # Adjust the width as needed

    
    # Convert the uploaded image to a PIL image
    pil_image = Image.open(image)
        
    # Convert the PIL image to a base64 string
    base64_image = image_to_base64_str(pil_image)
        
    # Generate caption using the image-to-text pipeline
    caption = get_completion(base64_image)
        
    # Display the generated caption
    st.success(caption[0]['generated_text'])
