import os

os.system('python -m pip install --upgrade pip')
os.system('pip install transformers torch')

import gradio as gr
from transformers import pipeline

unique_classes = [
    "Weak", 
    "Medium", 
    "Strong"
    ]

id2label = {f"LABEL_{idx}":label for idx, label in enumerate(unique_classes)}

def classify_password(text):
    password_clf = pipeline(model="DunnBC22/codebert-base-Password_Strength_Classifier")
    password_result = password_clf(text)
    return f"The password is {id2label[password_result[0]['label']]} with a probability of {password_result[0]['score']*100:.2f}"

title = "Classify Password Strength"
description = """
This is a demo of a password classifier. The feedback should not be taken as a guarantee of a password's strength.
"""

article = """
<p style='text-align: center'>
| <a href='https://arxiv.org/abs/2002.08155'>CodeBERT: A Pre-Trained Model for Programming & Natural Languages</a> 
| <a href='https://huggingface.co/microsoft/codebert-base'>Microsoft CodeBERT-Base Documentation</a>
| <a href='https://github.com/DunnBC22/NLP_Projects/blob/main/Password%20Strength%20Classification%20(MC)/CodeBERT-Base%20-%20Password_Classifier.ipynb'>My Code for this Fune-Tuned Project</a>
| <a href='https://www.kaggle.com/datasets/bhavikbb/password-strength-classifier-dataset'>Dataset Source</a>
|</p>
"""

examples = ['94311163nobp', 'mpompo1', 'dK4dWOjM1OAPeisw']

gr.Interface(fn=classify_password,
             inputs=gr.inputs.Textbox(),
             outputs=gr.outputs.Textbox(),
             title=title,
             article=article,
             description=description,
             examples=examples,
             theme='abidlabs/dracula_revamped'
             ).launch()