import streamlit as st
import random
import pickle
from sentiment import get_sentiment

# Load the data
novel_list = pickle.load(open('data/novel_list.pkl', 'rb'))
novel_list['english_publisher'] = novel_list['english_publisher'].fillna('unknown')
name_list = novel_list['name'].values

def recommend(novel, slider_start):
    try:
        similarity = pickle.load(open('data/similarity.pkl', 'rb'))
        novel_index = novel_list[novel_list['name'] == novel].index[0]
        distances = similarity[novel_index]
        new_novel_list = sorted(list(enumerate(distances)), reverse=True, key=lambda x: x[1])[slider_start:slider_start+9]
    except IndexError:
        return None

    recommend_novel = [{'name': novel_list.iloc[i[0]]['name'], 'image_url': novel_list.iloc[i[0]]['image_url'], 'english_publisher': novel_list.iloc[i[0]]['english_publisher']} for i in new_novel_list]
    return recommend_novel

def main():
    st.title("📚 Novel Recommender System")

    # Input fields and buttons
    selected_novel_name = st.text_input("🔎 Choose a Novel to get Recommendations", "Mother of Learning")
    slider_value = st.slider("Slider", 1, 100, 1)

    col1, col2, col3 = st.columns(3)  # Create three columns to place buttons side by side
    with col1:
        btn_recommend = st.button("💡 Recommend")
    with col2:
        btn_random = st.button("🎲 Random")
    with col3:
        btn_analysis = st.button("Analysis")

    if btn_recommend:
        recommendations = recommend(selected_novel_name, slider_value)
        if recommendations:
            for i in range(0, len(recommendations), 3):  # Process 3 recommendations at a time
                cols = st.columns(3)
                for j in range(3):
                    if i + j < len(recommendations):
                        novel = recommendations[i + j]
                        with cols[j]:
                            st.image(novel["image_url"], use_column_width=True)
                            st.write(novel["name"])
        else:
            st.warning("Novel not found in our database. Please try another one.")
    
    if btn_random:
        random_novels = random.sample(list(name_list), 9)
        for i in range(0, len(random_novels), 3):
            cols = st.columns(3)
            for j in range(3):
                if i + j < len(random_novels):
                    novel_name = random_novels[i + j]
                    novel_img = novel_list[novel_list['name'] == novel_name]['image_url'].values[0]
                    with cols[j]:
                        st.image(novel_img, use_column_width=True)
                        st.write(novel_name)

    if btn_analysis:
        try:
            positive, negative, wordcloud = get_sentiment(selected_novel_name)
            st.write(f"😊 {positive}% Positive")
            st.write(f"☹️ {negative}% Negative")
            print(wordcloud)
           
           

            st.image(wordcloud)

        except Exception as e:
            st.error("An error occurred during sentiment analysis.")
    
if __name__ == "__main__":
    main()
