import os

from sentence_transformers import SentenceTransformer, util
from PIL import Image
import glob

import pickle
import zipfile
from tqdm.autonotebook import tqdm
from pathlib import Path

from sentence_transformers import SentenceTransformer, util

import torch
torch.cuda.is_available = lambda : False
device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
# device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
# device = torch.device('cpu')
print("Device:", device)

import gradio as gr

from loguru import logger


I2I = "Text->Text"
T2I = "Text->Image"
I2I = "Image->Image"

model = SentenceTransformer("clip-ViT-B-32")
# load_model_path = 'xxxxxxx.pt'
# model = torch.load(load_model_path)
mode = model.to(device)
# mode = model.to('cpu')
print(next(model.parameters()).device)


img_folder = Path("./photos/")
# Next, we get about 25k images from Unsplash
if not os.path.exists(img_folder) or len(os.listdir(img_folder)) == 0:
    os.makedirs(img_folder, exist_ok=True)

    photo_filename = 'unsplash-25k-photos.zip'
    if not os.path.exists(photo_filename):  # Download dataset if does not exist
        util.http_get('http://sbert.net/datasets/' + photo_filename, photo_filename)

    # Extract all images
    with zipfile.ZipFile(photo_filename, 'r') as zf:
        for member in tqdm(zf.infolist(), desc='Extracting'):
            zf.extract(member, img_folder)

emb_filename = Path("unsplash-25k-photos-embeddings.pkl")
with open(emb_filename, "rb") as fIn:
    img_names, img_emb = pickle.load(fIn)

use_precomputed_embeddings = True
def compute_embeddings(use_precomputed_embeddings: bool = use_precomputed_embeddings):
    if use_precomputed_embeddings:
        emb_filename = 'unsplash-25k-photos-embeddings.pkl'
        if not os.path.exists(emb_filename):  # Download dataset if does not exist
            util.http_get('http://sbert.net/datasets/' + emb_filename, emb_filename)

        with open(emb_filename, 'rb') as fIn:
            img_names, img_emb = pickle.load(fIn)
        print("Images:", len(img_names))
    else:
        # For embedding images, we need the non-multilingual CLIP model
        img_model = SentenceTransformer('clip-ViT-B-32')
        img_names = list(glob.glob('photos/*.jpg'))
        print("Images:", len(img_names))
        img_emb = img_model.encode([Image.open(filepath) for filepath in img_names], batch_size=128,
                                   convert_to_tensor=True, show_progress_bar=True)
    return img_names, img_emb

img_names, img_emb = compute_embeddings()


# Cat image downloaded from https://www.flickr.com/photos/blacktigersdream/23119711630
cat_image = "./cat_example.jpg"
# Dog example downloaded from https://upload.wikimedia.org/wikipedia/commons/1/18/Dog_Breeds.jpg
dog_image = "./dog_example.jpg"

blank_image = "./blank_image.jpg"

# img = PIL.Image.open(img)
# Load CLIP model
model = SentenceTransformer('clip-ViT-B-32')

TEXT_FILE_PATTERN=os.getenv("TEXT_FILE_PATTERN", "./data-text/*.txt")
def embed_text_files(file_pattern="./data-text/*.txt"):
    texts_files = glob.glob(file_pattern)
    texts_=[]
    for text_file in texts_files:
        try:
            # Encode a text file:
            with open(text_file, 'r') as file:
                data = file.read().replace('\n', '')

            texts_.append(data)
        except IOError:
            print(f">>> ERROR: embed_text_files(): IOError: {text_file}")
            return None
    texts_emb = model.encode[texts_]
    return texts_files, texts_emb


IMAGE_FILE_PATTERN=os.getenv("IMAGE_FILE_PATTERN", "./photos/*.jpg")
def embed_image_files(file_pattern=IMAGE_FILE_PATTERN):
    imgs_files = glob.glob(file_pattern)
    imgs_emb=[]
    for img in imgs_files:
        try:
            # Encode an image:
            img_emb = model.encode(PIL.Image.open(img))
            imgs_emb.append(img_emb)
        except PIL.UnidentifiedImageError:
            print(f">>> ERROR: embed_text_files(): IOError: {img}")
            return None
    return imgs_files, imgs_emb


def search(image, mode, top_k, text):
    logger.info(f"Mode {mode} selected")
    if mode == I2I:
        logger.info(f"Processing image in mode {mode}")
        emb = model.encode([Image.fromarray(image)]) #, convert_to_tensor=True)
    elif mode == T2I:
        logger.info(f"Processing text in mode {mode}")
        emb = model.encode([text]) #, convert_to_tensor=True)

    print(f">>> emb Shape: {emb}")
    print(f">>> img_emb Shape: {img_emb}")

    cos_sim = util.cos_sim(img_emb, emb)
    print(f">>> cos_sim Shape: {cos_sim}")

    logger.info(f"Best match: {img_names[torch.argmax(cos_sim)]}")
    # return [Image.open(img_folder / img_names[top_k_best_image]) for top_k_best_image in torch.topk(cos_sim, 3, 0).indices]
    return [Image.open(img_folder / img_names[top_k_best_image]) for top_k_best_image in torch.topk(cos_sim, top_k, 0).indices]


if __name__ == "__main__":

    iface = gr.Interface(
        fn=search,
        inputs=[
            gr.inputs.Image(label="Image to search", optional=True),
            gr.inputs.Radio([T2I, I2I]),
            gr.inputs.Slider(1, 5, step=1, default=3),
            gr.inputs.Textbox(
                lines=1, label="Text query", placeholder="Introduce the search text...",
            ),
        ],
        theme="grass",
        outputs=gr.outputs.Carousel([gr.outputs.Image(type="pil")]),
        # outputs=[gr.outputs.Image(type="auto", label="1st Best match"),
        #          gr.outputs.Image(type="auto", label="2nd Best match"),
        #          gr.outputs.Image(type="auto", label="3rd Best match")],
        examples=[
            [cat_image, I2I, 3, ""],
            [dog_image, I2I, 3, ""],
            [blank_image, T2I, 5, "A white dog"],
            [blank_image, T2I, 3, "A black dog"],
            [blank_image, T2I, 3, "A cat"],
            [blank_image, T2I, 3, "Hugging Face"],
        ],
        # enable_queue=True,
        title="CLIP Image Search",
        description="Select the mode to search for a match in Unsplash (thumbnail size) dataset. text2image mode needs a text as input and outputs the image with the most similar embedding (following cosine similarity). The Image to image mode is similar, but an input image is used instead of a text query",
    )
    iface.launch()
