---
title: SD WebUI Plus Basics
emoji: 🐠
colorFrom: gray
colorTo: blue
sdk: docker
pinned: true
duplicated_from: MiroCollas/SD_WebUI_Plus_Basics
---

This is a modified version of the Space here: https://huggingface.co/spaces/Xenos14/XenoEngine-SD-webui

The original readme from that space follows my own comments.

I adapted that space in order to use the current release of SD WebUI, as well as current extensions. The original was pulling old versions, for some reason. I also removed all the female-centric embeds, and made a few fixes. Some extensions have also been disabled, since they are less suitable for a public space. Removing them also makes the UI moer responsive (the more extensions, the slower it is, I have found).

Added bug fix for https://github.com/AUTOMATIC1111/stable-diffusion-webui/issues/6840

If you like this space, duplicate it and customise it as you wish.

---

This is a modified version of the Space here: carloscar/stable-diffusion-webui-controlnet-docker

While it should still work fine with GPU upgrades (though untested), it has been optimized and set up with usage for a "no GPU" environment. I've removed a few extensions which won't work without a GPU and added a few more that help either performance or output quality in an environment without a GPU.


### Setup on Hugging Face

1. Duplicate this space to your Hugging Face account or clone this repo to your account.
2. The [`on_start.sh`](./on_start.sh) file will be run when the container is started, right before the WebUI is initiated. This is where you can install any additional extensions or models you may need. Make sure the env value `IS_SHARED_UI` is set to `0` or is unset for your space, or else only the lightweight model installation will run and some features will be disabled.

---

### Relevant links for more information

#### Repo for this builder

This repo, containing the `Dockerfile`, etc. for building the image can originally be found on both [`🤗 Hugging Face ➔ carloscar/stable-diffusion-webui-controlnet-docker`](https://huggingface.co/spaces/carloscar/stable-diffusion-webui-controlnet-docker) and [`🐙 GitHub ➔ kalaspuff/stable-diffusion-webui-controlnet-docker`](https://github.com/kalaspuff/stable-diffusion-webui-controlnet-docker).

#### Stable Diffusion Web UI

* Source Code: [https://github.com/AUTOMATIC1111/stable-diffusion-webui](https://github.com/AUTOMATIC1111/stable-diffusion-webui)
* Documentation: [https://github.com/AUTOMATIC1111/stable-diffusion-webui/wiki](https://github.com/AUTOMATIC1111/stable-diffusion-webui/wiki)

#### WebUI extension for ControlNet

* Source Code: [https://github.com/Mikubill/sd-webui-controlnet](https://github.com/Mikubill/sd-webui-controlnet)

#### ControlNet models

* Trained models: [https://github.com/lllyasviel/ControlNet](https://github.com/lllyasviel/ControlNet)
* Pre-extracted models: [https://huggingface.co/webui/ControlNet-modules-safetensors/tree/main](https://huggingface.co/webui/ControlNet-modules-safetensors/tree/main)

#### Licenses for using Stable Diffusion models and ControlNet models

* [https://huggingface.co/stabilityai/stable-diffusion-2/blob/main/LICENSE-MODEL](https://huggingface.co/stabilityai/stable-diffusion-2/blob/main/LICENSE-MODEL)
* [https://huggingface.co/spaces/CompVis/stable-diffusion-license](https://huggingface.co/spaces/CompVis/stable-diffusion-license)
* [https://github.com/lllyasviel/ControlNet/blob/main/LICENSE](https://github.com/lllyasviel/ControlNet/blob/main/LICENSE)

### Enable additional models (checkpoints, LoRA, VAE, etc.)

Enable the models you want to use on the bottom of the [`on_start.sh`](./on_start.sh) file. This is also the place to add any additional models you may want to install when starting your space.

```bash
## Checkpoint · Example:
download-model --checkpoint "FILENAME" "URL"

## LORA (low-rank adaptation) · Example:
download-model --lora "FILENAME" "URL"

## VAE (variational autoencoder) · Example:
download-model --vae "FILENAME" "URL"
```

#### Some examples of additional (optional) models

Some models such as additional checkpoints, VAE, LoRA, etc. may already be present in the [`on_start.sh`](./on_start.sh) file. You can enable them by removing the `#` in front of their respective line or disable them by removing the line or adding a leading `#` before `download-model`.

* [Checkpoint · Dreamlike Diffusion 1.0](https://huggingface.co/dreamlike-art/dreamlike-diffusion-1.0) ([license](https://huggingface.co/dreamlike-art/dreamlike-diffusion-1.0/blob/main/LICENSE.md))
* [Checkpoint · Dreamshaper 3.31](https://huggingface.co/Lykon/DreamShaper)
* [Checkpoint · The Ally's Mix III: Revolutions](https://civitai.com/models/10752/the-allys-mix-iii-revolutions)
* [Checkpoint · Deliberate v2](https://civitai.com/models/4823/deliberate)
* [Checkpoint · dalcefo_painting](https://civitai.com/models/5396/dalcefopainting)
* [Checkpoint · RPG v4](https://huggingface.co/Anashel/rpg)
* [Checkpoint · A to Zovya RPG Artist's Tools (1.5 & 2.1)](https://civitai.com/models/8124/a-to-zovya-rpg-artists-tools-15-and-21)
* [LoRA · epi_noiseoffset v2](https://civitai.com/models/13941/epinoiseoffset)
* [VAE · sd-vae-ft-mse-original](https://huggingface.co/stabilityai/sd-vae-ft-mse-original)
* [Embedding · bad_prompt_version2](https://huggingface.co/datasets/Nerfgun3/bad_prompt)
* See [https://huggingface.co/models?filter=stable-diffusion](https://huggingface.co/models?filter=stable-diffusion) and [https://civitai.com/](https://civitai.com/) for more.

Visit the individual model pages for more information on the models and their licenses.

### Additional acknowledgements

A lot of inspiration for this Docker build comes from [GitHub ➔ camenduru](https://github.com/camenduru). Amazing things! 🙏