import gradio as gr
from transformers import pipeline

generator = pipeline('text-generation', model='huggingface/bigscience/bloom-560m')

def generate(text):
    result = generator(text, max_length=100, num_return_sequences=1)
    return result[0]["generated_text"]

examples = [
    ["Zoe Kwan is a 20-year old singer and songwriter who has taken Hong Kong’s music scene by storm."],
    ["Zoe only recently began writing songs."],
]

demo = gr.Interface(fn=generate, inputs=gr.inputs.Textbox(lines=5, label="Input Text"), outputs=gr.outputs.Textbox(label="Generated Text"), 
                    title="Text Generator bloom-560m", examples=examples)

demo.launch()