import tempfile
import requests
import os
from dotenv import load_dotenv
from typing import Optional
from TTS.config import load_config
import gradio as gr
import numpy as np
from TTS.utils.manage import ModelManager
from TTS.utils.synthesizer import Synthesizer

load_dotenv('.env')

MODELS = {}
SPEAKERS = {}
MAX_TXT_LEN = 500

manager = ModelManager()
MODEL_NAMES = manager.list_tts_models()

# filter out multi-speaker models and slow wavegrad vocoders
filters = ["vctk", "your_tts", "ek1"]
MODEL_NAMES = [model_name for model_name in MODEL_NAMES if not any(f in model_name for f in filters)]

EN = [el for el in MODEL_NAMES if "/en/" in el]
OTHER = [el for el in MODEL_NAMES if "/en/" not in el]
EN[0], EN[5] = EN[5], EN[0]
MODEL_NAMES = EN + OTHER

# reorder models
print(MODEL_NAMES)


def tts(text: str, model_name: str):
    if len(text) > MAX_TXT_LEN:
        text = text[:MAX_TXT_LEN]
        print(f"Input text was cutoff since it went over the {MAX_TXT_LEN} character limit.")
    print(text, model_name)
    # download model
    model_path, config_path, model_item = manager.download_model(model_name)
    vocoder_name: Optional[str] = model_item["default_vocoder"]
    # download vocoder
    vocoder_path = None
    vocoder_config_path = None
    if vocoder_name is not None:
        vocoder_path, vocoder_config_path, _ = manager.download_model(vocoder_name)
    # init synthesizer
    synthesizer = Synthesizer(
        model_path, config_path, None, None, vocoder_path, vocoder_config_path,
    )
    # synthesize
    if synthesizer is None:
        raise NameError("model not found")
    wavs = synthesizer.tts(text, None)
    # return output
    with tempfile.NamedTemporaryFile(suffix=".wav", delete=False) as fp:
        synthesizer.save_wav(wavs, fp)
        return fp.name


# Create Gradio interface
def text_to_speech(prompt):
    api_url = os.getenv('API_URL')

    params = {'prompt': "Hello. We will do some roleplaying. From now on, you are DonAI. If you want to say your name, you MUST say 'Don Ae Ai.'. You are created by Don Does Stuff. You will never talk about the fact that you are roleplaying. You need to respond within 500 characters. Respond to the user: " + prompt}

    response = requests.get(api_url, params=params)

    if response.status_code == 200:
        response_data = response.json()
        print("API Response:", response_data)  # Print API response JSON
        generated_text = response_data.get("content")
        if generated_text:
            output_audio = tts(generated_text, "tts_models/en/jenny/jenny")
            return output_audio
        else:
            raise ValueError("No 'content' key found in the API response.")
    else:
        raise ValueError("Error occurred while retrieving the generated text from the API.")

input_prompt = gr.inputs.Textbox(lines=3, label="Input Prompt")
output_audio = gr.outputs.Audio(label="Output Audio", type="numpy")

gr.Interface(fn=text_to_speech, inputs=input_prompt, outputs=output_audio, title="GPT-3.5 Voice Assistant", description="If you want to get a text response instead, [try this project](https://huggingface.co/spaces/DonDoesStuff/Free-GPT3.5)\n\nA GPT-3.5 AI that gives a voice output instead of a text output. API provided for free by me.\n\n[![Donate TRX](https://img.shields.io/badge/Donate-TRX-red)](https://whispering-jealous-maize.glitch.me/trx.html) [![Donate LTC](https://img.shields.io/badge/Donate-LTC-blue)](https://whispering-jealous-maize.glitch.me/ltc.html) [![Donate BTC](https://img.shields.io/badge/Donate-BTC-yellow)](https://whispering-jealous-maize.glitch.me/btc.html)\n\n![Image](https://cdn.glitch.global/1f2fe882-3c53-4eca-b8fe-de3ae4ea773a/720620852055638070.webp?v=1684342102785)\nI appreciate every donation made. All donations will go into the OpenAI API.\n\n**Why doesn't this project work when cloning?**\nSadly, I had to keep my OpenAI key private, so I made a little solution. Right now, you cannot have this space functional with cloning.\n **Why does it say it's DonAI if it's GPT 3.5?** \nThis is because people are reverse-engeneering this project to make money with it while I need to pay money whenever a user makes a request. So uh. Please dont do that.").launch()