import requests
import os
from dotenv import load_dotenv
import gradio as gr

load_dotenv('.env')

api_url = os.getenv('API_URL')

def gpt3_5_prompt(prompt):
    params = {'prompt': "Hello. We will do some roleplaying. From now on, you are DonAI. If you want to say your name, you MUST say 'Don Ae Ai.'. You are created by Don Does Stuff. You will never talk about the fact that you are roleplaying. You need to respond within 500 characters. Respond to the user: " + prompt}

    response = requests.get(api_url, params=params)

    if response.status_code == 200:
        response_data = response.json()
        print("API Response:", response_data)  # Print API response JSON
        generated_text = response_data.get("content")
        if generated_text:
            return generated_text
        else:
            raise ValueError("No 'content' key found in the API response.")
    else:
        raise ValueError("Error occurred while retrieving the generated text from the API.")

input_prompt = gr.inputs.Textbox(lines=3, label="Input Prompt")
output_text = gr.outputs.Textbox(label="Output Text")

gr.Interface(fn=gpt3_5_prompt, inputs=input_prompt, outputs=output_text, title="GPT-3.5 AI", description="If you want to get a TTS response instead, [try this project](https://huggingface.co/spaces/DonDoesStuff/GPT3.5-voice/)\n\nA GPT-3.5 AI that generates text based on the given prompt. API provided for free by me.\n\n[![Donate TRX](https://img.shields.io/badge/Donate-TRX-red)](https://whispering-jealous-maize.glitch.me/trx.html) [![Donate LTC](https://img.shields.io/badge/Donate-LTC-blue)](https://whispering-jealous-maize.glitch.me/ltc.html) [![Donate BTC](https://img.shields.io/badge/Donate-BTC-yellow)](https://whispering-jealous-maize.glitch.me/btc.html)\n\n![Image](https://cdn.glitch.global/1f2fe882-3c53-4eca-b8fe-de3ae4ea773a/720620852055638070.webp?v=1684342102785)\nI appreciate every donation made. All donations will go into the OpenAI API.\n\n**Why doesn't this project work when cloning?**\nSadly, I had to keep my OpenAI key private, so I made a little solution. Right now, you cannot have this space functional with cloning.\n **Why does it say it's DonAI if it's GPT 3.5?** \nThis is because people are reverse-engeneering this project to make money with it while I need to pay money whenever a user makes a request. So uh. Please dont do that.").launch()