import asyncio
import gradio as gr
from EdgeGPT import Chatbot, ConversationStyle

bot = None

async def generate_response(prompt):
    global bot
    if bot is None:
        bot = await Chatbot.create()
    response = await bot.ask(prompt='' + prompt, conversation_style=ConversationStyle.creative)
    message = response['item']['messages'][-1]
    bot = await Chatbot.create()  # Create a new instance for the next prompt
    return message

desc = "Interact with Bing AI, you can ask questions in this chatbox. The response will be given in [JSON format](https://lava.st/tdh9g.png).\n\nYou may get an error message. This most likely happens because of a limit on the number of requests from this server's IP address. To avoid this problem, you can clone the space.\n\n[![Donate TRX](https://img.shields.io/badge/Donate-TRX-red)](https://whispering-jealous-maize.glitch.me/trx.html) [![Donate LTC](https://img.shields.io/badge/Donate-LTC-blue)](https://whispering-jealous-maize.glitch.me/ltc.html) [![Donate BTC](https://img.shields.io/badge/Donate-BTC-yellow)](https://whispering-jealous-maize.glitch.me/btc.html)\n\n![Image](https://cdn.glitch.global/1f2fe882-3c53-4eca-b8fe-de3ae4ea773a/720620852055638070.webp?v=1684342102785)"

iface = gr.Interface(
    fn=generate_response,
    inputs="text",
    outputs="text",
    title="Bing AI Chatbot",
    description=desc
)
iface.launch()