# This class stores Polly voice data. Specifically, the class stores several records containing
# language, lang_code, gender, voice_id and engine. The class also has a method to return the
# voice_id, lang_code and engine given a language and gender.

NEURAL_ENGINE = "neural"
STANDARD_ENGINE = "standard"


class PollyVoiceData:
    def get_voice(self, language, gender):
        for voice in self.voice_data:
            if voice['language'] == language and voice['gender'] == gender:
                if voice['neural'] == 'Yes':
                    return voice['voice_id'], voice['lang_code'], NEURAL_ENGINE
        for voice in self.voice_data:
            if voice['language'] == language and voice['gender'] == gender:
                if voice['standard'] == 'Yes':
                    return voice['voice_id'], voice['lang_code'], STANDARD_ENGINE
        return None, None, None

    def get_whisper_lang_code(self, language):
        for voice in self.voice_data:
            if voice['language'] == language:
                return voice['whisper_lang_code']
        return "en"

    def __init__(self):
        self.voice_data = [
            {'language': 'Arabic',
             'lang_code': 'arb',
             'whisper_lang_code': 'ar',
             'voice_id': 'Zeina',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Arabic (Gulf)',
             'lang_code': 'ar-AE',
             'whisper_lang_code': 'ar',
             'voice_id': 'Hala',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Catalan',
             'lang_code': 'ca-ES',
             'whisper_lang_code': 'ca',
             'voice_id': 'Arlet',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Chinese (Cantonese)',
             'lang_code': 'yue-CN',
             'whisper_lang_code': 'zh',
             'voice_id': 'Hiujin',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Chinese (Mandarin)',
             'lang_code': 'cmn-CN',
             'whisper_lang_code': 'zh',
             'voice_id': 'Zhiyu',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Danish',
             'lang_code': 'da-DK',
             'whisper_lang_code': 'da',
             'voice_id': 'Naja',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Danish',
             'lang_code': 'da-DK',
             'whisper_lang_code': 'da',
             'voice_id': 'Mads',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Dutch',
             'lang_code': 'nl-NL',
             'whisper_lang_code': 'nl',
             'voice_id': 'Laura',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Dutch',
             'lang_code': 'nl-NL',
             'whisper_lang_code': 'nl',
             'voice_id': 'Lotte',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Dutch',
             'lang_code': 'nl-NL',
             'whisper_lang_code': 'nl',
             'voice_id': 'Ruben',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'English (Australian)',
             'lang_code': 'en-AU',
             'whisper_lang_code': 'en',
             'voice_id': 'Nicole',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'English (Australian)',
             'lang_code': 'en-AU',
             'whisper_lang_code': 'en',
             'voice_id': 'Olivia',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'English (Australian)',
             'lang_code': 'en-AU',
             'whisper_lang_code': 'en',
             'voice_id': 'Russell',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'English (British)',
             'lang_code': 'en-GB',
             'whisper_lang_code': 'en',
             'voice_id': 'Amy',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (British)',
             'lang_code': 'en-GB',
             'whisper_lang_code': 'en',
             'voice_id': 'Emma',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (British)',
             'lang_code': 'en-GB',
             'whisper_lang_code': 'en',
             'voice_id': 'Brian',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (British)',
             'lang_code': 'en-GB',
             'whisper_lang_code': 'en',
             'voice_id': 'Arthur',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'English (Indian)',
             'lang_code': 'en-IN',
             'whisper_lang_code': 'en',
             'voice_id': 'Aditi',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'English (Indian)',
             'lang_code': 'en-IN',
             'whisper_lang_code': 'en',
             'voice_id': 'Raveena',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'English (Indian)',
             'lang_code': 'en-IN',
             'whisper_lang_code': 'en',
             'voice_id': 'Kajal',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'English (New Zealand)',
             'lang_code': 'en-NZ',
             'whisper_lang_code': 'en',
             'voice_id': 'Aria',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'English (South African)',
             'lang_code': 'en-ZA',
             'whisper_lang_code': 'en',
             'voice_id': 'Ayanda',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Ivy',
             'gender': 'Female (child)',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Joanna',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Kendra',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Kimberly',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Salli',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Joey',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Justin',
             'gender': 'Male (child)',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Kevin',
             'gender': 'Male (child)',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'English (US)',
             'lang_code': 'en-US',
             'whisper_lang_code': 'en',
             'voice_id': 'Matthew',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'English (Welsh)',
             'lang_code': 'en-GB-WLS',
             'whisper_lang_code': 'en',
             'voice_id': 'Geraint',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Finnish',
             'lang_code': 'fi-FI',
             'whisper_lang_code': 'fi',
             'voice_id': 'Suvi',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'French',
             'lang_code': 'fr-FR',
             'whisper_lang_code': 'fr',
             'voice_id': 'Celine',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'French',
             'lang_code': 'fr-FR',
             'whisper_lang_code': 'fr',
             'voice_id': 'Lea',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'French',
             'lang_code': 'fr-FR',
             'whisper_lang_code': 'fr',
             'voice_id': 'Mathieu',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'French (Canadian)',
             'lang_code': 'fr-CA',
             'whisper_lang_code': 'fr',
             'voice_id': 'Chantal',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'French (Canadian)',
             'lang_code': 'fr-CA',
             'whisper_lang_code': 'fr',
             'voice_id': 'Gabrielle',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'French (Canadian)',
             'lang_code': 'fr-CA',
             'whisper_lang_code': 'fr',
             'voice_id': 'Liam',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'German',
             'lang_code': 'de-DE',
             'whisper_lang_code': 'de',
             'voice_id': 'Marlene',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'German',
             'lang_code': 'de-DE',
             'whisper_lang_code': 'de',
             'voice_id': 'Vicki',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'German',
             'lang_code': 'de-DE',
             'whisper_lang_code': 'de',
             'voice_id': 'Hans',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'German',
             'lang_code': 'de-DE',
             'whisper_lang_code': 'de',
             'voice_id': 'Daniel',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'German (Austrian)',
             'lang_code': 'de-AT',
             'whisper_lang_code': 'de',
             'voice_id': 'Hannah',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Hindi',
             'lang_code': 'hi-IN',
             'whisper_lang_code': 'hi',
             'voice_id': 'Aditi',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Hindi',
             'lang_code': 'hi-IN',
             'whisper_lang_code': 'hi',
             'voice_id': 'Kajal',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Icelandic',
             'lang_code': 'is-IS',
             'whisper_lang_code': 'is',
             'voice_id': 'Dora',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Icelandic',
             'lang_code': 'is-IS',
             'whisper_lang_code': 'is',
             'voice_id': 'Karl',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Italian',
             'lang_code': 'it-IT',
             'whisper_lang_code': 'it',
             'voice_id': 'Carla',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Italian',
             'lang_code': 'it-IT',
             'whisper_lang_code': 'it',
             'voice_id': 'Bianca',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Japanese',
             'lang_code': 'ja-JP',
             'whisper_lang_code': 'ja',
             'voice_id': 'Mizuki',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Japanese',
             'lang_code': 'ja-JP',
             'whisper_lang_code': 'ja',
             'voice_id': 'Takumi',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Korean',
             'lang_code': 'ko-KR',
             'whisper_lang_code': 'ko',
             'voice_id': 'Seoyeon',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Norwegian',
             'lang_code': 'nb-NO',
             'whisper_lang_code': 'no',
             'voice_id': 'Liv',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Norwegian',
             'lang_code': 'nb-NO',
             'whisper_lang_code': 'no',
             'voice_id': 'Ida',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Polish',
             'lang_code': 'pl-PL',
             'whisper_lang_code': 'pl',
             'voice_id': 'Ewa',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Polish',
             'lang_code': 'pl-PL',
             'whisper_lang_code': 'pl',
             'voice_id': 'Maja',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Polish',
             'lang_code': 'pl-PL',
             'whisper_lang_code': 'pl',
             'voice_id': 'Jacek',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Polish',
             'lang_code': 'pl-PL',
             'whisper_lang_code': 'pl',
             'voice_id': 'Jan',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Polish',
             'lang_code': 'pl-PL',
             'whisper_lang_code': 'pl',
             'voice_id': 'Ola',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Portuguese (Brazilian)',
             'lang_code': 'pt-BR',
             'whisper_lang_code': 'pt',
             'voice_id': 'Camila',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Portuguese (Brazilian)',
             'lang_code': 'pt-BR',
             'whisper_lang_code': 'pt',
             'voice_id': 'Vitoria',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Portuguese (Brazilian)',
             'lang_code': 'pt-BR',
             'whisper_lang_code': 'pt',
             'voice_id': 'Ricardo',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Portuguese (European)',
             'lang_code': 'pt-PT',
             'whisper_lang_code': 'pt',
             'voice_id': 'Ines',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Portuguese (European)',
             'lang_code': 'pt-PT',
             'whisper_lang_code': 'pt',
             'voice_id': 'Cristiano',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Romanian',
             'lang_code': 'ro-RO',
             'whisper_lang_code': 'ro',
             'voice_id': 'Carmen',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Russian',
             'lang_code': 'ru-RU',
             'whisper_lang_code': 'ru',
             'voice_id': 'Tatyana',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Russian',
             'lang_code': 'ru-RU',
             'whisper_lang_code': 'ru',
             'voice_id': 'Maxim',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Spanish (European)',
             'lang_code': 'es-ES',
             'whisper_lang_code': 'es',
             'voice_id': 'Conchita',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Spanish (European)',
             'lang_code': 'es-ES',
             'whisper_lang_code': 'es',
             'voice_id': 'Lucia',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Spanish (European)',
             'lang_code': 'es-ES',
             'whisper_lang_code': 'es',
             'voice_id': 'Enrique',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Spanish (Mexican)',
             'lang_code': 'es-MX',
             'whisper_lang_code': 'es',
             'voice_id': 'Mia',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Spanish (US)',
             'lang_code': 'es-US',
             'whisper_lang_code': 'es',
             'voice_id': 'Lupe',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'Yes'},
            {'language': 'Spanish (US)',
             'lang_code': 'es-US',
             'whisper_lang_code': 'es',
             'voice_id': 'Penelope',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Spanish (US)',
             'lang_code': 'es-US',
             'whisper_lang_code': 'es',
             'voice_id': 'Miguel',
             'gender': 'Male',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Spanish (US)',
             'lang_code': 'es-US',
             'whisper_lang_code': 'es',
             'voice_id': 'Pedro',
             'gender': 'Male',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Swedish',
             'lang_code': 'sv-SE',
             'whisper_lang_code': 'sv',
             'voice_id': 'Astrid',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Swedish',
             'lang_code': 'sv-SE',
             'whisper_lang_code': 'sv',
             'voice_id': 'Elin',
             'gender': 'Female',
             'neural': 'Yes',
             'standard': 'No'},
            {'language': 'Turkish',
             'lang_code': 'tr-TR',
             'whisper_lang_code': 'tr',
             'voice_id': 'Filiz',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'},
            {'language': 'Welsh',
             'lang_code': 'cy-GB',
             'whisper_lang_code': 'cy',
             'voice_id': 'Gwyneth',
             'gender': 'Female',
             'neural': 'No',
             'standard': 'Yes'}
        ]


# Run from the command-line
if __name__ == '__main__':
    polly_voice_data = PollyVoiceData()

    voice_id, language_code, engine = polly_voice_data.get_voice('English (US)', 'Male')
    print('English (US)', 'Male', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('English (US)', 'Female')
    print('English (US)', 'Female', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('French', 'Female')
    print('French', 'Female', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('French', 'Male')
    print('French', 'Male', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('Japanese', 'Female')
    print('Japanese', 'Female', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('Japanese', 'Male')
    print('Japanese', 'Male', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('Hindi', 'Female')
    print('Hindi', 'Female', voice_id, language_code, engine)

    voice_id, language_code, engine = polly_voice_data.get_voice('Hindi', 'Male')
    print('Hindi', 'Male', voice_id, language_code, engine)

    whisper_lang_code = polly_voice_data.get_whisper_lang_code('English (US)')
    print('English (US) whisper_lang_code:', whisper_lang_code)

    whisper_lang_code = polly_voice_data.get_whisper_lang_code('Chinese (Mandarin)')
    print('Chinese (Mandarin) whisper_lang_code:', whisper_lang_code)

    whisper_lang_code = polly_voice_data.get_whisper_lang_code('Norwegian')
    print('Norwegian whisper_lang_code:', whisper_lang_code)

    whisper_lang_code = polly_voice_data.get_whisper_lang_code('Dutch')
    print('Dutch whisper_lang_code:', whisper_lang_code)

    whisper_lang_code = polly_voice_data.get_whisper_lang_code('Foo')
    print('Foo whisper_lang_code:', whisper_lang_code)


