import gradio as gr
import matplotlib.pyplot as plt
import numpy as np
import PIL
import tensorflow as tf

from tensorflow import keras
from tensorflow.keras import layers
from tensorflow.keras.models import Sequential

from keras.models import load_model
model1 = load_model('model1.h5')

class_names = ['daisy', 'dandelion', 'roses', 'sunflowers', 'tulips'] 
def predict_image(img):
  img_4d=img.reshape(-1,180,180,3)
  prediction=model1.predict(img_4d)[0]
  return {class_names[i]: float(prediction[i]) for i in range(5)}

image = gr.inputs.Image(shape=(180,180))
label = gr.outputs.Label(num_top_classes=3)
enable_queue=True
description="This is a Flower Classification Model made using a CNN.Deployed to Hugging Faces using Gradio."
examples = ['dandelion.jpg','sunflower.jpeg','tulip.jpg']
article="<p style='text-align: center'>Made by Aditya Narendra with 🖤</p>"


gr.Interface(fn=predict_image, inputs=image, outputs=label,title="Flower Classifier",description=description,article=article,examples=examples,enable_queue=enable_queue,interpretation='default').launch(debug='True')