# Workaround to install the lib without "setup.py"
import sys
from git import Repo
Repo.clone_from("https://github.com/dimitreOliveira/hub.git", "./hub")
sys.path.append("/hub")

import gradio as gr
from hub.tensorflow_hub.hf_utils import pull_from_hub
from sklearn.metrics.pairwise import cosine_similarity

model = pull_from_hub(repo_id="Dimitre/universal-sentence-encoder")

def get_similarity(sentence_a, sentence_b):
    embed_a = model([sentence_a])
    embed_b = model([sentence_b])
    similarity = cosine_similarity(embed_a, embed_b)[0][0]
    return f'The similarity score between sentence A and sentence B is: "{similarity:.2f}"'

iface = gr.Interface(fn=get_similarity, 
                     title="Sentence similarity", 
                     description="Measure the similarity between sentences using universal-sentence-encoder", 
                     inputs=[gr.Textbox(lines=2, placeholder="Sentence A here...", label="Sentence A"), 
                             gr.Textbox(lines=2, placeholder="Sentence B here...", label="Sentence B")], 
                     outputs="text",
                     examples=[["Hello! This is a random sentence", "Hello! This is a slightly different random sentence"]])
iface.launch()