---
title: README
emoji: 👁
colorFrom: yellow
colorTo: purple
sdk: static
pinned: false
---

[![](https://github.com/langgenius/dify/raw/main/images/describe-en.png)](https://github.com/langgenius/dify)

#### [Website](https://dify.ai) • [Docs](https://docs.dify.ai) • [Deployment Docs](https://docs.dify.ai/getting-started/install-self-hosted) •  [FAQ](https://docs.dify.ai/getting-started/faq) • [Twitter](https://twitter.com/dify_ai) • [Discord](https://discord.gg/FngNHpbcY7)

**Dify** is an easy-to-use LLMOps platform designed to empower more people to create sustainable, AI-native applications. With visual orchestration for various application types, Dify offers out-of-the-box, ready-to-use applications that can also serve as Backend-as-a-Service APIs. Unify your development process with one API for plugins and datasets integration, and streamline your operations using a single interface for prompt engineering, visual analytics, and continuous improvement.

Applications created with Dify include:

Out-of-the-box web sites supporting form mode and chat conversation mode
A single API encompassing plugin capabilities, context enhancement, and more, saving you backend coding effort
Visual data analysis, log review, and annotation for applications

<video controls autoplay src="https://cdn-uploads.huggingface.co/production/uploads/644b553391252984f647f771/aI5hmBGAcK2eI-K87lpig.mp4"></video>

## Highlighted Features
**1. LLMs support:** Choose capabilities based on different models when building your Dify AI apps. Dify is compatible with Langchain, meaning it will support various LLMs. Currently supported:  

- **OpenAI**: GPT4, GPT3.5-turbo, GPT3.5-turbo-16k, text-davinci-003   
- **Azure OpenAI Service**  
- **Anthropic**: Claude2, Claude-instant    
- **Replicate**  
- **Hugging Face Hub**  
- **ChatGLM**  
- **Llama2**  
- **MiniMax**  
- **Spark**  
- **Wenxin**  
- **Tongyi**  


We provide the following free resources for registered Dify cloud users (sign up at [dify.ai](https://dify.ai)):
* 600,000 free Claude model tokens to build Claude-powered apps
* 200 free OpenAI queries to build OpenAI-based apps

  
**2. Visual orchestration:** Build an AI app in minutes by writing and debugging prompts visually.

**3. Text embedding:** Fully automated text preprocessing embeds your data as context without complex concepts. Supports PDF, TXT, and syncing data from Notion, webpages, APIs.

**4. API-based:**  Backend-as-a-service. Access web apps directly or integrate via APIs without complex backend setup.

**5. Plugins:** Dify "Smart Chat" now supports first-party plugins like web browsing, Google search, Wikipedia to enable online lookup, analyzing web content, and explaining the AI's reasoning process conversationally.

**6. Team workspaces:** Team members can join workspaces to collaboratively edit, manage, and use team AI apps.

**7. Data labeling and improvement:**  Visually inspect AI app logs and improve data via labeling. Observe the AI's reasoning process to continuously enhance performance. (Coming soon)

## Use cases
* [Create an AI ChatBot with Business Data in Minutes.](https://docs.dify.ai/use-cases/create-an-ai-chatbot-with-business-data-in-minutes)
* [How to Build an Notion AI Assistant Based on Your Own Notes?](https://docs.dify.ai/use-cases/build-an-notion-ai-assistant)
* [Create a Midjoureny Prompt Bot Without Code in Just a Few Minutes.](https://docs.dify.ai/use-cases/create-a-midjoureny-prompt-bot-with-dify)

## Use Cloud Services

Visit [Dify.ai](https://dify.ai)

## Contact Us

If you have any questions, suggestions, or partnership inquiries, feel free to contact us through the following channels:

- Submit an Issue or PR on our GitHub Repo
- Join the discussion in our [Discord](https://discord.gg/FngNHpbcY7) Community
- Send an email to hello@dify.ai

We're eager to assist you and together create more fun and useful AI applications!