import gradio as gr
import requests
from PIL import Image
from io import BytesIO
import base64

api_url = "https://5cb20b40-572c-426f-9466-995256f9b6eb.id.repl.co/generate_image"

def generate_image(model="Deliberate", prompt="", seed=0, negative_prompt="", sampler="k_dpmpp_2s_a", steps=50):
    data = "?model=" + model + "&prompt=" + prompt + "&seed=" + str(seed) + "&negative_prompt=" + negative_prompt + "&sampler=" + sampler + "&steps=" + str(steps)
    response = requests.post(api_url + data, timeout=400)
    if response.status_code == 200:
        img_base64 = response.json()["url"]
        img_bytes = base64.b64decode(img_base64)
        img = Image.open(BytesIO(img_bytes))
        return img
    else:
        return None

inputs = [
         gr.inputs.Dropdown(['3DKX', 'Abyss OrangeMix', 'AbyssOrangeMix-AfterDark', 'ACertainThing',
    'AIO Pixel Art', 'Analog Diffusion', 'Anime Pencil Diffusion', 'Anygen',
    'Anything Diffusion', 'Anything v3', 'anything_v4_inpainting',
    'App Icon Diffusion', 'Arcane Diffusion', 'Archer Diffusion',
    'Asim Simpsons', 'A to Zovya RPG', 'Balloon Art', 'Borderlands', 'BPModel',
    'BubblyDubbly', 'Char', 'CharHelper', 'Cheese Daddys Landscape Mix',
    'ChilloutMix', 'ChromaV5', 'Classic Animation Diffusion', 'Clazy',
    'Colorful', 'Coloring Book', 'Comic-Diffusion', 'Concept Sheet',
    'Counterfeit', 'Cyberpunk Anime Diffusion', 'CyriousMix',
    'Dan Mumford Style', 'Darkest Diffusion', 'Dark Victorian Diffusion',
    'Deliberate', 'DGSpitzer Art Diffusion', 'Disco Elysium', 'DnD Item',
    'Double Exposure Diffusion', 'Dreamlike Diffusion',
    'dreamlike_diffusion_inpainting', 'Dreamlike Photoreal',
    'DreamLikeSamKuvshinov', 'Dreamshaper', 'DucHaiten',
    'DucHaiten Classic Anime', 'Dungeons and Diffusion', 'Dungeons n Waifus',
    'Eimis Anime Diffusion', 'Elden Ring Diffusion', "Elldreth's Lucid Mix",
    'Elldreths Retro Mix', 'Epic Diffusion', 'Eternos', 'Experience',
    'ExpMix Line', 'FaeTastic', 'Fantasy Card Diffusion', 'FKing SciFi',
    'Funko Diffusion', 'Furry Epoch', 'Future Diffusion', 'Ghibli Diffusion',
    'GorynichMix', 'Grapefruit Hentai', 'Graphic-Art',
    'GTA5 Artwork Diffusion', 'GuoFeng', 'Guohua Diffusion', 'HASDX',
    'Hassanblend', "Healy's Anime Blend", 'Hentai Diffusion', 'HRL', 'iCoMix',
    'Illuminati Diffusion', 'Inkpunk Diffusion', 'Jim Eidomode',
    'JWST Deep Space Diffusion', 'Kenshi', 'Knollingcase', 'Korestyle',
    'kurzgesagt', 'Laolei New Berry Protogen Mix', "Lawlas's yiff mix",
    'Liberty', 'Marvel Diffusion', 'Mega Merge Diffusion', 'Microcasing',
    'Microchars', 'Microcritters', 'Microscopic', 'Microworlds',
    'Midjourney Diffusion', 'Midjourney PaintArt', 'Min Illust Background',
    'ModernArt Diffusion', 'mo-di-diffusion', 'Moedel', 'MoistMix',
    'Movie Diffusion', 'NeverEnding Dream', 'Nitro Diffusion', 'Openniji',
    'OrbAI', 'Papercutcraft', 'Papercut Diffusion', 'Pastel Mix',
    'Perfect World', 'PFG', 'PIXHELL', 'Poison', 'Pokemon3D', 'PortraitPlus',
    'PPP', 'Pretty 2.5D', 'PRMJ', 'Project Unreal Engine 5', 'ProtoGen',
    'Protogen Anime', 'Protogen Infinity', 'Pulp Vector Art', 'PVC',
    'Rachel Walker Watercolors', 'Rainbowpatch', 'Ranma Diffusion',
    'RCNZ Dumb Monkey', 'RCNZ Gorilla With A Brick', 'RealBiter',
    'Realism Engine', 'Realistic Vision', 'Redshift Diffusion', 'Rev Animated',
    'Robo-Diffusion', 'Rodent Diffusion', 'RPG', 'Samdoesarts Ultmerge',
    'Sci-Fi Diffusion', 'SD-Silicon', 'Seek.art MEGA', 'Smoke Diffusion',
    'Something', 'Sonic Diffusion', 'Spider-Verse Diffusion',
    'Squishmallow Diffusion', 'stable_diffusion', 'stable_diffusion_2.1',
    'stable_diffusion_2_inpainting', 'Supermarionation', 'Sygil-Dev Diffusion',
    'Synthwave', 'SynthwavePunk', 'TrexMix', 'trinart', 'Trinart Characters',
    'Tron Legacy Diffusion', 'T-Shirt Diffusion', 'T-Shirt Print Designs',
    'Uhmami', 'Ultraskin', 'UMI Olympus', 'Unstable Ink Dream', 'URPM',
    'Valorant Diffusion', 'Van Gogh Diffusion', 'Vector Art', 'vectorartz',
    'Vintedois Diffusion', 'VinteProtogenMix', 'Vivid Watercolors',
    'Voxel Art Diffusion', 'waifu_diffusion', 'Wavyfusion', 'Woop-Woop Photo',
    'Xynthii-Diffusion', 'Yiffy', 'Zack3D', 'Zeipher Female Model',
    'Zelda BOTW'], label="Model", default="Deliberate"),
    gr.inputs.Textbox(label="Prompt", default=""),
    gr.inputs.Number(label="Seed", default=0),
    gr.inputs.Textbox(label="Negative Prompt", default=""),
    gr.inputs.Dropdown(["k_lms", "k_heun", "k_euler", "k_euler_a", "k_dpm_2", "k_dpm_2_a", "DDIM", "k_dpm_fast", "k_dpm_adaptive", "k_dpmpp_2m", "k_dpmpp_2s_a", "k_dpmpp_sde"], label="Sampler", default="k_dpmpp_2s_a"),
    gr.inputs.Number(label="Steps", default=50)
]

outputs = gr.outputs.Image(label="Generated Image", type="pil")

interface = gr.Interface(generate_image, inputs, outputs, title="Diffusion 200", 
                         description="<center>Live access to Top 200 Diffusion models</center>", 
                         examples=[])

interface.launch()
