import gradio as gr
import requests
from PIL import Image
from io import BytesIO
import base64

api_url = "https://5cb20b40-572c-426f-9466-995256f9b6eb.id.repl.co/generate_image"

def generate_image(model="Abyss OrangeMix", prompt="", seed=0, negative_prompt="", sampler="k_dpmpp_2s_a", steps=50):
    data = "?model=" + model + "&prompt=" + prompt + "&seed=" + str(seed) + "&negative_prompt=" + negative_prompt + "&sampler=" + sampler + "&steps=" + str(steps)
    response = requests.post(api_url + data, timeout=400)
    if response.status_code == 200:
        img_base64 = response.json()["url"]
        img_bytes = base64.b64decode(img_base64)
        img = Image.open(BytesIO(img_bytes))
        return img
    else:
        return None

inputs = [
     gr.inputs.Dropdown(['Abyss OrangeMix', 'AbyssOrangeMix-AfterDark','Anime Pencil Diffusion', 'Anygen', 'Anything Diffusion', 'Anything v3', 'anything_v4_inpainting', 'Arcane Diffusion', 'BPModel', 'Counterfeit', 'Cyberpunk Anime Diffusion', 'CyriousMix', 'DGSpitzer Art Diffusion', 'Dreamshaper', 'DucHaiten Classic Anime',  'Eimis Anime Diffusion', 'Ghibli Diffusion',   'GuoFeng', 'Hentai Diffusion', 'Kenshi', 'Midjourney Diffusion',  'NeverEnding Dream',  'Openniji', 'Pastel Mix', 'Protogen Anime', 'Rev Animated'], label="Model", default="Abyss OrangeMix"),
    gr.inputs.Textbox(label="Prompt"),
    gr.inputs.Number(label="Seed", default=0),
    gr.inputs.Textbox(label="Negative Prompt", default=""),
    gr.inputs.Dropdown(["k_lms", "k_heun", "k_euler", "k_euler_a", "k_dpm_2", "k_dpm_2_a", "DDIM", "k_dpm_fast", "k_dpm_adaptive", "k_dpmpp_2m", "k_dpmpp_2s_a", "k_dpmpp_sde"], label="Sampler", default="k_dpmpp_2s_a"),
    gr.inputs.Number(label="Steps", default=50)
]

outputs = gr.outputs.Image(label="Generated Image", type="pil")

interface = gr.Interface(generate_image, inputs, outputs, title="", 
                         description="<center></center>", 
                         examples=[])

interface.launch() 


