import cv2
import pytesseract
import gradio as gr

# ------------------------- Function to extract text from an image -------------------------
def extract_text_from_image(image):
    gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)  # Convert the image from BGR to grayscale
    text = pytesseract.image_to_string(gray)  # Extract text from the grayscale image
    return text


#------------------------------- Graphic interface --------------------------------
# Define Gradio interface
iface = gr.Interface(
    fn=extract_text_from_image, 
    inputs=gr.Image (label="Upload Image"), 
    outputs="text",
    title="OCR APP ",
    description="Upload an image and we'll extract the text for you.",
    
)

# Launch Gradio Interface
iface.launch(share= True)


