from turtle import width
import gradio as gr
from utils import SampleClass

sample = SampleClass()

# --- Interface ---

demo = gr.Blocks(
            title="Categories_error_analysis.ipynb",
            css=".container { max-width: 98%; margin: auto;};")

with demo:
    gr.Markdown("<h2><center> Categories Error Analysis 🐛</center></h2>")
    with gr.Row():
        with gr.Column():
            with gr.Row():
                category = gr.Dropdown(label="Category",value="relational",choices=["intrinsic","spatial","ordinal","relational","plural"])
                predictions = gr.Dropdown(label='Predictions', value='fail',choices=["fail", "correct"])
            with gr.Row():
                model = gr.Dropdown(label='Model', value='baseline', choices=["baseline", "extended"])
                split = gr.Dropdown(label='Split',value='val',choices=["test","val"])
            with gr.Row():
                username = gr.Dropdown(label="UserName",value="luciana",choices=["luciana",'mauri','jorge','nano'])
                next_idx_sample = gr.Number(label='Next Idx Sample', value=0)
            with gr.Row():
                progress = gr.Label(label='Progress',num_top_classes=10)
            with gr.Row(): 
                btn_next = gr.Button("Get Next Sample")

        with gr.Column():
            with gr.Row():
                img = gr.Image(label="Sample", type="numpy")
            with gr.Row():
                info = gr.Text(label="Info")
                img_seg = gr.Image(label="Segmentation", type="numpy")

    btn_next.click(
        fn=sample.explorateSamples,
        inputs=[username,predictions,category,model,split,next_idx_sample], 
        outputs=[next_idx_sample, progress, img, info, img_seg])

demo.queue(concurrency_count=10)
demo.launch(debug=False)