import gradio as gr
import requests

def check_interaction(drug1, drug2):
    API_ENDPOINT = "https://api.fda.gov/drug/event.json"
    SEARCH_TEMPLATE = '?search=patient.drug.medicinalproduct:{}+AND+patient.drug.medicinalproduct:{}&count=patient.reaction.reactionmeddrapt.exact'

    search_string = SEARCH_TEMPLATE.format(drug1, drug2)
    response = requests.get(API_ENDPOINT + search_string)
    data = response.json()

    if "results" in data:
        interactions = [result['term'] for result in data['results']]
        return interactions
    else:
        return "No known interactions"

iface = gr.Interface(fn=check_interaction,
                     inputs=["text", "text"],
                     outputs="text")

iface.launch()
