---
title: LinearRegression
emoji: 💻
colorFrom: green
colorTo: gray
sdk: gradio
sdk_version: 3.23.0
app_file: app.py
pinned: false
---

#Linear Regression
Linear regression is a statistical method used to model the relationship between a dependent variable (often denoted as Y) and one or more independent variables (often denoted as X). The goal of linear regression is to find the line (or plane in higher dimensions) that best fits the data, by minimizing the distance between the predicted values and the actual values. The equation of the line can then be used to predict the value of the dependent variable for any given value of the independent variable. Linear regression is widely used in many fields, including economics, finance, and engineering, among others.

![Linear Regression Image](https://media.geeksforgeeks.org/wp-content/uploads/linear-regression-plot.jpg)

#Deployed
Created a Model that would take inputs and outputs and Train itself and adjust its weights and bias since The model only involves one node with bias it is easy to predict the weights and bias

#Code 
```
import torch
import torch.nn as nn
from tqdm import tqdm

w = float(input("Enter weight : "))
b = float(input("Enter Bias : "))

x = torch.randn(1000)
y = (x*w)+b

class Lreg(nn.Module):
    def __init__(self):
        super(Lreg,self).__init__()
        self.l = nn.Linear(1,1)

    def forward(self,x):
        y = self.l(x)
        return y

model = Lreg()
crit = nn.MSELoss()
optim = torch.optim.SGD(model.parameters(),lr=0.01)

model.train()
for i in tqdm(range(1,5)):
    for idx,ele in enumerate(x):
        ele = ele.unsqueeze(0)
        out = model(ele)
        optim.zero_grad()
        loss = crit(out,y[idx].unsqueeze(0))
        loss.backward()
        optim.step()
print(loss.item())

model.eval()
t = torch.tensor([7],dtype=torch.float32)
print("expected output ",t*w+b)
rout = model(t)
print(rout.item())
c = model.state_dict()
print(f'The wieght is {c["l.weight"].item()} and the bias is {c["l.bias"].item()}')
```

Made By Devic1 🖤
Check out the configuration reference at https://huggingface.co/docs/hub/spaces-config-reference