import gradio as gr
import requests
import time
from PIL import Image
import json
import base64

Prompt = "realistic photo of 3d cartoon style of a cat in a space suit with milky way background"

def txt2img(Prompt, Negative_prompt='', Model='DreamLike'):
  if Model == "OpenJourney":
    prodia_model = "openjourney_V4.ckpt [ca2f377f]"
  elif Model == "AnyThing":
    prodia_model = "anything-v4.5-pruned.ckpt [65745d25]"
  else:
    prodia_model = "dreamlike-diffusion-2.0.safetensors [fdcf65e7]"

  url = "https://api.prodia.com/v1/job"
  payload = {
            "prompt": Prompt,
            "negative_prompt": Negative_prompt,
            "steps": 25,
            "cfg_scale": 7,
            "seed": -1,
            "model": prodia_model,
            "upscale": True,
            "sampler": "DPM++ 2M Karras",
            "aspect_ratio": 'square',
        }
  headers = {
            "accept": "application/json",
            "content-type": "application/json",
            "X-Prodia-Key": '8baba6df-dea4-4e76-95da-606797e4fe23',
        }
  response = requests.post(
                url,
                json=payload,
                headers=headers
            )
  response_data = response.json()
  jobid = response_data["job"]
  request_url = f"https://api.prodia.com/v1/job/{jobid}"
  while True:
    try:
      response = requests.get(request_url, headers=headers)
      response_data = response.json()
      image_link = response_data["imageUrl"]
      break
    except:
      pass
  img = Image.open(requests.get(image_link, stream = True).raw)
  img.save('greenland_02a.png')
  return img

#txt2img(Prompt, Negative_prompt='', Model='DreamLike')

def img2txt(caption_image):

  with open(caption_image, 'rb') as f:
    img_data = f.read()
  url = 'data:image/png;base64,' + base64.b64encode(img_data).decode('utf-8')

  def asticaAPI(endpoint, payload, timeout):
      response = requests.post(endpoint, data=payload, timeout=timeout, verify=False)
      if response.status_code == 200:
          return response.json()
      else:
          return {'status': 'error', 'error': 'Failed to connect to the API.'}

  asticaAPI_key = '9F1359AD-C0C7-4F2B-8C53-25908E7E72E91F129226-A850-4C5C-A381-FFC077AFE9A0'
  asticaAPI_timeout = 35

  asticaAPI_endpoint = 'https://astica.ai:9141/vision/describe'
  asticaAPI_modelVersion = '1.0_full'

  asticaAPI_input = url
  asticaAPI_visionParams = 'gpt,description'

  asticaAPI_payload = {
      'tkn': asticaAPI_key,
      'modelVersion': asticaAPI_modelVersion,
      'visionParams': asticaAPI_visionParams,
      'input': asticaAPI_input,
  }

  asticaAPI_result = asticaAPI(asticaAPI_endpoint, asticaAPI_payload, asticaAPI_timeout)

  if 'status' in asticaAPI_result:
      if asticaAPI_result['status'] == 'error':
          print('Output:\n', asticaAPI_result['error'])
      if asticaAPI_result['status'] == 'success':
          if 'caption_GPTS' in asticaAPI_result and asticaAPI_result['caption_GPTS'] != '':
              gpt_caption = asticaAPI_result['caption_GPTS']
              print('GPT Caption:', gpt_caption)
          if 'caption' in asticaAPI_result and asticaAPI_result['caption']['text'] != '':
              caption = asticaAPI_result['caption']['text']
              print('Caption:', caption)
          return [gpt_caption, caption]
  else:
      return ['Invalid Response', 'No response']

txt2img = gr.Interface(
    txt2img,
    inputs=[
        gr.Text(label='Prompt'),
        gr.Text(label='Negative Prompt'),
        gr.Dropdown(label='Models', choices=["DreamLike", "OpenJourney", "AnyThing"], value='Dreamlike', allow_custom_value=False),
    ],
    outputs = gr.Image(label='Output'),
    title = 'AI Image Generator')

img2txt = gr.Interface(
    img2txt,
    inputs= gr.Image(type="filepath", label='Input'),
    outputs = [gr.Text(label='Detailed Caption'), gr.Text(label='Caption')],
    title = 'Image Captioning')


demo = gr.TabbedInterface([txt2img, img2txt], ["Txt2Img", "Img2Txt"], title="AI Image Tools" )

demo.launch(debug = True)
