import wifi_qrcode_generator
import gradio as gr

examples = [['Home wifi', 'very complicated password', 'WPA']]

def infer(wifi_name, wifi_pw, authentication_type):
    image = wifi_qrcode_generator.wifi_qrcode(
      wifi_name, False, authentication_type, wifi_pw
    )
    image.save('qrcode_wifi.png')
    return 'qrcode_wifi.png'

description= "Generate code for accessing WIFI. Fill your wifi name, wifi password and select authentication type. Then click submit and enjoy 😎"

iface = gr.Interface(
    fn=infer,
    title="Generate QR code for accessing WIFI 🥃",
    description=description,
    inputs=[
        gr.Textbox(
            label="Wifi name",
            lines=1,
        ),
        gr.Textbox(
            label="Wifi password",
            lines=1,
        ),
        gr.Dropdown(
            label='authentication_type',
            choices=["WPA", "WEP", "nopass"], 
            value='WPA'
        ),
    ],
    outputs="image",
    examples=examples,
    article="Author: <a href=\"https://huggingface.co/vumichien\">Vu Minh Chien</a>", cache_examples=True).launch(enable_queue=True)
