var express = require('express');
var router = express.Router();
var textToSpeech = require('../helpers/tts');
var callOpenAI = require('../helpers/callOpenAI');  // Import the helper function

function logRequestBody(req, res, next) {
  console.log('Request body:', req.body);
  next();
}

router.post('/talk', logRequestBody, async function(req, res, next) {
  try {
    const ttsResult = await textToSpeech(req.body.text, req.body.language);
    res.json(ttsResult);

  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

router.post('/chat', logRequestBody, async function(req, res, next) {
  try {
    const userContent = req.body.text;
    const openAIResponse = await callOpenAI(userContent);

    res.json({ response: openAIResponse });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

router.get('/', function(req, res, next) {
  res.send("AI avatar backend is running.");
});

module.exports = router;
