const OpenAI = require('openai');

const openai = new OpenAI({
    apiKey: process.env.OPENAI_API_KEY, // defaults to process.env["OPENAI_API_KEY"]
    dangerouslyAllowBrowser: true
});

async function queryOpenAIAndSave(userContent) {
    const response = await openai.chat.completions.create({
        model: "gpt-3.5-turbo",
        messages: [
            {"role": "system", "content": "You are a helpful assistant made by Detomo company. Please answer the following questions with maximum 2 sentence. Answer by the language of the question."},
            {"role": "user", "content": userContent},
        ],
    });

    return response.choices[0].message.content;
}

module.exports = queryOpenAIAndSave;