import numpy as np
import gradio as gr
from huggingface_hub import from_pretrained_keras
import keras
import tensorflow as tf

model = from_pretrained_keras("keras-io/lowlight-enhance-mirnet", compile=False)
examples = ['examples/1.png', 'examples/55.png', 'examples/665.png', 'examples/778.png']


def infer(original_image):
    image = tf.keras.preprocessing.image.img_to_array(original_image)
    image = image.astype("float32") / 255.0
    image = np.expand_dims(image, axis=0)
    output = model.predict(image)
    output_image = output[0] * 255.0
    output_image = output_image.clip(0, 255)
    output_image = output_image.reshape(
        (np.shape(output_image)[0], np.shape(output_image)[1], 3)
    )
    output_image = np.uint32(output_image)
    return output_image

iface = gr.Interface(
    fn=infer,
    title="Low light image enhancement",
    description = "MIRNet model for light up the dark image 🌆🎆",
    inputs=[gr.inputs.Image(label="image", type="pil", shape=(960, 640))],
    outputs="image",
    cache_examples=True,
    article = "Author: <a href=\"https://huggingface.co/vumichien\">Vu Minh Chien</a>.",
    examples=examples).launch(enable_queue=True)